         name      showargs
         title     SHOWARGS -- ARGC and ARGV demo
;
; SHOWARGS.ASM --- demonstrate command line parsing
;                  with ARGC.ASM and ARGV.ASM 
;
; (C) 1987 Ray Duncan
;

stdin   equ     0               ; MS-DOS handles for
stdout  equ     1               ; standard devices
stderr  equ     2

cmdtail equ     80h             ; offset of command tail
                                ; in program segment prefix

cr      equ     0dh             ; ASCII carriage return
lf      equ     0ah             ; ASCII line feed
blank   equ     020h            ; ASCII blank
tab     equ     09h             ; ASCII tab 

        extrn   argc:near       ; returns argument count
        extrn   argv:near       ; returns pointer to argument

DGROUP  group   _DATA,STACK

_TEXT   segment word public 'CODE'

        assume  cs:_TEXT,ds:DGROUP,ss:STACK

main    proc    far             ; entry point from MS-DOS

        mov     ax,DGROUP       ; make our data segment
        mov     ds,ax           ; addressable

        mov     psp,es          ; save segment of PSP

        mov     bx,cmdtail      ; ES:BX = command tail
        call    argc            ; get number of command 
                                ;  line arguments       
        mov     pars,ax         ; and save it

        mov     bx,offset msg1a ; convert count to ASCII
        call    b2dec           ;  for output

        mov     dx,offset msg1  ; display the number of
        mov     cx,msg1_len     ;  command line arguments
        mov     bx,stdout
        mov     ah,40h
        int     21h

main1:  mov     ax,count        ; display next argument
        cmp     ax,pars         ; are we all done?      
        je      main2           ; yes, exit

        mov     bx,offset msg2a ; no, convert argument number
        call    b2dec

        mov     dx,offset msg2  ; and display the number
        mov     cx,msg2_len
        mov     bx,stdout
        mov     ah,40h
        int     21h

        mov     ax,count        ; now get the actual argument
        mov     es,psp          ; ES:BX = command tail
        mov     bx,cmdtail
        call    argv

        push    ds              ; save our data segment and
        push    es              ;  display argument string
        pop     ds
        mov     dx,bx           ; now DS:DX = argument addr
        mov     cx,ax           ; and CX = argument length
        mov     bx,stdout
        mov     ah,40h
        int     21h
        pop     ds              ; restore our data segment

        inc     word ptr count  ; go to next argument
        jmp     main1

main2:  mov     ax,4c00h        ; exit to MS-DOS
        int     21h

main    endp


b2dec   proc    near            ; convert binary value 0-99
                                ;  to decimal ASCII chars.
                                ; call with 
                                ; AL = binary data
                                ; BX = addr. for 2 chars.
        
        aam                     ; divide AL by 10, leaving
                                ; AH=quotient, AL=remainder
        add     ax,'00'         ; convert to ASCII
        mov     [bx],ah         ; store ten's digit
        mov     [bx+1],al       ; store one's digit
        ret                     ; return to caller

b2dec   endp

_TEXT   ends


_DATA   segment word public 'DATA'

count   dw      0               ; current command line argument
pars    dw      0               ; total command line arguments
psp     dw      0               ; save segment of PSP

msg1    db      cr,lf
        db      'The command line contains '
msg1a   db      'xx arguments'
msg1_len equ $-msg1

msg2    db      cr,lf
        db      'Argument '
msg2a   db      'xx is:  '
msg2_len equ $-msg2

_DATA   ends


STACK   segment para stack 'STACK'

        dw      64 dup (?)

STACK   ends

        end     main
