DEFINT A-Z
'$INCLUDE: 'qb.bi'

DIM SHARED InRegs AS RegType, OutRegs AS RegType
DIM SHARED Drive, PSP
DIM Buffer AS STRING * 11

IF LEN(COMMAND$) THEN
     Drive = ASC(LEFT$(COMMAND$, 1)) - 64
ELSE

     InRegs.ax = &H1900
     INTERRUPT &H21, InRegs, OutRegs
     Drive = (OutRegs.ax AND 255) + 1
END IF




'GetDriveInfo
InRegs.ax = &H3600
InRegsters.dx = Drive
INTERRUPT &H21, InRegs, OutRegs
IF OutRegs.ax = &HFFFF THEN
PRINT "Invalid Drive"
ELSE
ClusterSize& = CLNG(OutRegs.ax) * CLNG(OutRegs.cx)
TotalBytes& = CLNG(OutRegs.dx) * ClusterSize&
FreeBytes& = CLNG(OutRegs.bx) * ClusterSize&

PRINT "Drive: "; CHR$(Drive + 64)
RSET Buffer = STR$(TotalBytes&)
PRINT Buffer; " bytes total disk space"
RSET Buffer = STR$(FreeBytes&)
PRINT Buffer; " bytes available disk space"
PRINT
END IF


'GetMemory

InRegs.ax = &H6200
INTERRUPT &H21, InRegs, OutRegs
PSP = OutRegs.bx
INTERRUPT &H12, InRegs, OutRegs
MemSize& = OutRegs.ax * 64&
RSET Buffer = STR$(CLNG(OutRegs.ax) * 1024&)
PRINT Buffer; " bytes total memory"
RSET Buffer = STR$((MemSize& - CLNG(PSP) + 1&) * 16&)
PRINT Buffer; " bytes free memory"
PRINT
PRINT "  Next program will load at "; HEX$(PSP); ":0000 hex"
PRINT

