' Note: This is a version of SKELETON.BAS which has machine language coding,
'       allowing use of the routines without requiring the BIN files.

DEFINT A-Z
TYPE RegTypeX
   AX    AS INTEGER
   BX    AS INTEGER
   CX    AS INTEGER
   DX    AS INTEGER
   BP    AS INTEGER
   SI    AS INTEGER
   DI    AS INTEGER
   Flags AS INTEGER
   DS    AS INTEGER
   ES    AS INTEGER
END TYPE
DIM SHARED Regs AS RegTypeX
DECLARE SUB Interrupt (IntNum%, Regs AS RegTypeX)
DECLARE SUB BlockCopy (FromSeg%, FromOfs%, ToSeg%, ToOfs%, Count%)
DECLARE SUB SLBox (Top%, Lft%, Bot%, Rgt%, Attr%, Shad%)

'
' Your Code Here
'

END

MemCopy:
   DATA 85, 139, 236, 86, 87, 30, 6, 139, 94, 12
   DATA 139, 55, 139, 94, 10, 142, 7, 139, 94, 8
   DATA 139, 63, 139, 94, 6, 139, 15, 139, 94, 14
   DATA 142, 31, 252, 243, 164, 7, 31, 95, 94, 93
   DATA 202, 10, 0, -1

IntCode:
   DATA 85, 139, 236, 131, 236, 8, 86, 87, 30, 85
   DATA 139, 94, 6, 139, 71, 16, 61, 255, 255, 117
   DATA 4, 30, 143, 71, 16, 139, 71, 18, 61, 255
   DATA 255, 117, 4, 30, 143, 71, 18, 139, 71, 8
   DATA 137, 70, 248, 139, 7, 139, 79, 4, 139, 87
   DATA 6, 139, 119, 10, 139, 127, 12, 255, 119, 18
   DATA 7, 255, 119, 2, 30, 143, 70, 250, 255, 119
   DATA 16, 31, 139, 110, 248, 91, 205, 33, 85, 139
   DATA 236, 139, 110, 2, 137, 94, 252, 139, 94, 6
   DATA 30, 143, 70, 254, 255, 118, 250, 31, 137, 7
   DATA 139, 70, 252, 137, 71, 2, 137, 79, 4, 137
   DATA 87, 6, 88, 137, 71, 8, 137, 119, 10, 137
   DATA 127, 12, 156, 143, 71, 14, 6, 143, 71, 18
   DATA 139, 70, 254, 137, 71, 16, 90, 31, 95, 94
   DATA 139, 229, 93, 202, 2, 0, -1

SLBox:
   DATA 85, 139, 236, 131, 236, 10, 139, 94, 16, 138
   DATA 7, 136, 70, 249, 254, 78, 249, 139, 94, 14
   DATA 138, 7, 136, 70, 250, 254, 78, 250, 139, 94
   DATA 14, 138, 7, 136, 70, 248, 139, 94, 12, 138
   DATA 7, 136, 70, 251, 254, 78, 251, 139, 94, 10
   DATA 138, 7, 136, 70, 252, 254, 78, 252, 139, 94
   DATA 8, 138, 7, 136, 70, 253, 139, 94, 6, 138
   DATA 7, 136, 70, 254, 138, 70, 252, 42, 70, 250
   DATA 254, 200, 117, 2, 254, 192, 136, 70, 247, 138
   DATA 70, 249, 136, 70, 255, 82, 180, 2, 42, 255
   DATA 138, 118, 255, 138, 86, 250, 205, 16, 90, 180
   DATA 9, 176, 218, 42, 255, 138, 94, 253, 51, 201
   DATA 177, 1, 205, 16, 82, 180, 2, 42, 255, 138
   DATA 118, 255, 138, 86, 248, 205, 16, 90, 180, 9
   DATA 176, 196, 42, 255, 138, 94, 253, 51, 201, 138
   DATA 78, 247, 205, 16, 82, 180, 2, 42, 255, 138
   DATA 118, 255, 138, 86, 252, 205, 16, 90, 180, 9
   DATA 176, 191, 42, 255, 138, 94, 253, 51, 201, 177
   DATA 1, 205, 16, 254, 70, 255, 138, 70, 251, 56
   DATA 70, 255, 117, 3, 235, 91, 144, 82, 180, 2
   DATA 42, 255, 138, 118, 255, 138, 86, 250, 205, 16
   DATA 90, 180, 9, 176, 179, 42, 255, 138, 94, 253
   DATA 51, 201, 177, 1, 205, 16, 82, 180, 2, 42
   DATA 255, 138, 118, 255, 138, 86, 248, 205, 16, 90
   DATA 180, 9, 176, 32, 42, 255, 138, 94, 253, 51
   DATA 201, 138, 78, 247, 205, 16, 82, 180, 2, 42
   DATA 255, 138, 118, 255, 138, 86, 252, 205, 16, 90
   DATA 180, 9, 176, 179, 42, 255, 138, 94, 253, 51
   DATA 201, 177, 1, 205, 16, 235, 152, 82, 180, 2
   DATA 42, 255, 138, 118, 255, 138, 86, 250, 205, 16
   DATA 90, 180, 9, 176, 192, 42, 255, 138, 94, 253
   DATA 51, 201, 177, 1, 205, 16, 82, 180, 2, 42
   DATA 255, 138, 118, 255, 138, 86, 248, 205, 16, 90
   DATA 180, 9, 176, 196, 42, 255, 138, 94, 253, 51
   DATA 201, 138, 78, 247, 205, 16, 82, 180, 2, 42
   DATA 255, 138, 118, 255, 138, 86, 252, 205, 16, 90
   DATA 180, 9, 176, 217, 42, 255, 138, 94, 253, 51
   DATA 201, 177, 1, 205, 16, 128, 126, 254, 0, 117
   DATA 3, 233, 138, 0, 254, 70, 251, 254, 70, 250
   DATA 254, 70, 250, 82, 180, 2, 42, 255, 138, 118
   DATA 251, 138, 86, 250, 205, 16, 90, 180, 8, 42
   DATA 255, 205, 16, 180, 9, 187, 8, 0, 185, 1
   DATA 0, 205, 16, 138, 70, 250, 44, 2, 58, 70
   DATA 252, 124, 213, 254, 70, 252, 138, 70, 249, 136
   DATA 70, 255, 138, 86, 252, 136, 86, 252, 254, 70
   DATA 255, 82, 180, 2, 42, 255, 138, 118, 255, 138
   DATA 86, 252, 205, 16, 90, 180, 8, 42, 255, 205
   DATA 16, 180, 9, 187, 8, 0, 185, 1, 0, 205
   DATA 16, 254, 70, 252, 82, 180, 2, 42, 255, 138
   DATA 118, 255, 138, 86, 252, 205, 16, 90, 180, 8
   DATA 42, 255, 205, 16, 180, 9, 187, 8, 0, 185
   DATA 1, 0, 205, 16, 138, 70, 255, 58, 70, 251
   DATA 124, 179, 139, 229, 93, 202, 12, 0, -1

SUB BlockCopy (FromSeg, FromOfs, ToSeg, ToOfs, Count)
   STATIC MemCopy$
   IF NOT LEN(MemCopy$) THEN
      RESTORE MemCopy:
      READ X
      WHILE X > -1
         A$ = CHR$(X)
         MemCopy$ = MemCopy$ + A$
         READ X
      WEND
   END IF
   DEF SEG = VARSEG(MemCopy$)
   CALL Absolute(FromSeg, FromOfs, ToSeg, ToOfs, Count, SADD(MemCopy$))
END SUB

SUB Interrupt (IntNum, Regs AS RegTypeX) STATIC
   STATIC FileNum, IntOffset, Loaded
   DIM IntCode AS STRING * 200

   IF NOT Loaded THEN                        ' loaded will be 0 first time
      RESTORE IntCode:
      A$ = ""
      READ X
      WHILE X > -1
         A$ = A$ + CHR$(X)
         READ X
      WEND
      IntCode = A$
      IntOffset = INSTR(IntCode$, CHR$(&HCD) + CHR$(&H21)) + 1 ' int # offset
      Loaded = -1
   END IF
   SELECT CASE IntNum
      CASE &H25, &H26, IS > 255               ' ignore these interrupts
      CASE ELSE
         DEF SEG = VARSEG(IntCode)             ' poke interrupt number into
         POKE VARPTR(IntCode) * 1& + IntOffset - 1, IntNum' code block
         CALL Absolute(Regs, VARPTR(IntCode$)) ' call routine
   END SELECT
END SUB

SUB SLBox (Top, Lft, Bot, Rgt, Attr, Shad)
   STATIC SLB$, BinLoaded

   IF NOT BinLoaded THEN
      RESTORE SLBox:
      READ X
      WHILE X > -1
         A$ = CHR$(X)
         SLB$ = SLB$ + A$
         READ X
      WEND
      BinLoaded = -1
   END IF
   DEF SEG = VARSEG(SLB$)
   CALL Absolute(Top, Lft, Bot, Rgt, Attr, Shad, SADD(SLB$))
END SUB
