PROGRAM T_EGB_0a;

{ PGM FOR DEMONSTRATING THE tBufTextFileReader ACCESS OBJECT }

{ This programs reads an AutoCAD DXF text file with an access object
  of tBufTextFileReader class and then with one of the
  tBufTextStringFileReader class.

{ Pgm. 07/19/95 by John F Herbster for CIS Delphi Object Pascal Lib. }

{-----} USES {---------------------------------------------------------}
  U_EGB_0a in 'U_EGB_0A.PAS',
  U_EGD_0a in 'U_EGD_0A.PAS',
  SysUtils,WinCrt;

VAR
  GenReader: tBufferedFileScanner;
  StrReader: tBufTextStringFileReader;
  pRec: pByteArray; LghRec: word; line: string;

{=====} BEGIN {========================================================}

  Writeln('Using tBufTextFileReader as a tBufferedFileReader');
{ Create an instance of the class which openes the file and allocates
  a buffer.  Note that the "Reader" is of the abstract class.  }
  GenReader:=tBufTextFileScanner.Create('TEST.DXF',128,98);
{ As long as LocNextVarLghRec function method can find a next record
  keep doing the loop. }
  With GenReader do while LocNextVarLghRec(pRec,LghRec) do begin
  { Copy the line out of the buffer using the pointer, pRec. }
(*  byte(line[0]):=LghRec; Move(pRec^,line[1],LghRec);
  { Write the line out. }
    WriteLn(' "',line,'"'); *)
    end;
{ Return the buffer back to the system.}
  Dispose(GenReader,Destroy);

  Writeln('Using tBufTextStringFileReader as itself');
{ Create an instance of the class which openes the file and allocates
  a buffer.  Now the TextReader is of the actual object class.  }
  StrReader:=tBufTextStringFileReader.Create('TEST.DXF',128);
{ As long as LocNextVarLghRec function method can find a next record
  keep doing the loop. }
  With StrReader do while GotLine(line) do begin
  { Write the line out. (Or just selected lines.) }
    If (line='EOF')
      then WriteLn(LnNbr:5,' "',line,'"');
    end;
{ Return the buffer back to the system and do any other cleanup.}
  Dispose(StrReader,Destroy);
  WriteLn('Finished');

{=====} END. {=========================================================}

