unit Aniunit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Animate;

type
  TForm1 = class(TForm)
    Bulb: TAnimated;
    BulbButton: TButton;
    Coins: TAnimated;
    CoinButton: TButton;
    Pencil: TAnimated;
    TrafficLight: TAnimated;
    TrafficLightButton: TButton;
    Crumble: TAnimated;
    CrumbleButton: TButton;
    Explode: TAnimated;
    ExplodeButton: TButton;
    Bomb: TAnimated;
    BombButton: TButton;
    procedure BulbClick(Sender: TObject);
    procedure CoinClick(Sender: TObject);
    procedure TrafficLightClick(Sender: TObject);
    procedure CrumbleClick(Sender: TObject);
    procedure ExplodeClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure BombClick(Sender: TObject);
    procedure BombChangeFrame(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses MMSystem;

{$R *.DFM}

procedure TForm1.BulbClick(Sender: TObject);
begin
with Sender as TButton do
  if Caption = 'Off' then
    begin
    Bulb.Frame := 1;
    Caption := 'On';
    end
  else
    begin
    Bulb.Frame := 0;
    Caption := 'Off';
    end;
end;

procedure TForm1.CoinClick(Sender: TObject);
begin
with Coins do
  begin
  Reverse := not Reverse;
  Play := True;
  end;
end;

procedure TForm1.TrafficLightClick(Sender: TObject);
begin
with TrafficLight do
  Frame := Frame + 1;  {Incrementing wraps around at FrameCount}
end;

procedure TForm1.CrumbleClick(Sender: TObject);
begin
with Crumble do
  begin
  Reverse := not Reverse;
  Play := True;
  end;
end;

procedure TForm1.ExplodeClick(Sender: TObject);
begin
with Explode do
  begin
  Reverse := not Reverse;
  Play := True;
  end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
Pencil.Play := True;
end;

procedure TForm1.BombClick(Sender: TObject);
begin
with Bomb do
  if Frame = 0 then
    Play := True
  else
    Frame := 0;
end;

procedure TForm1.BombChangeFrame(Sender: TObject);
const
  snd_Async           = $0001;  { play asynchronously }
begin
if (Bomb.Frame = 8) then
    SndPlaySound('explode.wav', snd_ASync);
end;

end.
