unit Acropths;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ThesDlg;

type
  TAcropThesaurus = class(TComponent)
  private
    { Private declarations }
    ThesDataPtr    : pointer;
    FThesaurusFile : string;
    FShowFullList  : boolean;
    FLeaveOpen     : boolean;
    FThesOpen      : boolean;
    ThesDialog     : TThesaurusDlg;
  protected
    { Protected declarations }
  public
    { Public declarations }
    property ThesaurusOpen : boolean read FThesOpen;
    constructor Create(AOwner : TComponent); override;
    procedure Free;
  published
    { Published declarations }
    property ThesaurusFile : string read FThesaurusFile write FThesaurusfile;
    property ShowFullList : boolean read FShowFullList write FShowFullList default TRUE;
    property LeaveFileOpen : boolean read FLeaveOpen write FLeaveOpen default FALSE;
    function FindThesaurusEntry(Target : string; var Desired : string) : boolean;
    procedure CloseThesaurus;
  end;

procedure Register;

implementation

uses BaseAThs;


procedure Register;
begin
  RegisterComponents('Samples', [TAcropThesaurus]);
end;

constructor TAcropThesaurus.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FThesaurusFile := 'acrop.sar';
  FShowFullList  := TRUE;
  FLeaveOpen     := FALSE;
  FThesOpen      := FALSE;
  ThesDialog     := TThesaurusDlg.Create(Self);
  BaseAThs.InitThesaurusData(ThesDataPtr);
end;

procedure TAcropThesaurus.Free;
begin
  if FThesOpen then
    BaseAThs.CloseThesaurus(ThesDataPtr);
  ThesDialog.Free;
  BaseAThs.ReleaseThesaurusData(ThesDataPtr);
  inherited Free;
end;

procedure TAcropThesaurus.CloseThesaurus;
begin
  if FThesOpen then
    BaseAThs.CloseThesaurus(ThesDataPtr);
  FThesOpen := FALSE;
end;

function TAcropThesaurus.FindThesaurusEntry(Target : string; var Desired : string) : boolean;
begin
  try
    if not FThesOpen then
      FThesOpen := BaseAThs.OpenThesaurus(ThesDataPtr, FThesaurusFile);
    if not FThesOpen then
      begin
        FindThesaurusEntry := FALSE;
        exit;
      end;
    ThesDialog.FullList := FShowFullList;
    if ThesDialog.Execute(ThesDataPtr, Target) then
      begin
        Desired := ThesDialog.DesiredWord;
        FindThesaurusEntry := TRUE;
      end
    else
      begin
        Desired := Target;
        FindThesaurusEntry := FALSE;
      end;
  finally
    if not FLeaveOpen then
      begin
        BaseAThs.CloseThesaurus(ThesDataPtr);
        FThesOpen := FALSE;
      end;
  end;
end;

end.
