unit Thesdlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TThesaurusDlg = class(TForm)
    EntryList: TListBox;
    WordEdit: TEdit;
    BtnRepace: TButton;
    BtnBack: TButton;
    BtnTop: TButton;
    Button1: TButton;
    procedure FormShow(Sender: TObject);
    procedure EntryListDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BtnBackClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure BtnRepaceClick(Sender: TObject);
    procedure BtnTopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure EntryListDblClick(Sender: TObject);
  private
    { Private declarations }
    ThesaurusDataPtr : pointer;
    StackList        : TStringList;
    CloseList        : boolean;
    RootWord         : string;
    procedure PushStack(s : string);
    function PopStack : string;
  public
    { Public declarations }
     FullList   : boolean;
     DesiredWord : string;
     function Execute(ThesPtr : pointer; TheWord : string) : boolean;
  end;

var
  ThesaurusDlg: TThesaurusDlg;

implementation

{$R *.DFM}

uses BaseAThs;


procedure TThesaurusDlg.PushStack(s : string);
begin
  StackList.Add(S);
end;

function TThesaurusDlg.PopStack : string;
begin
  if StackList.Count = 0 then
    PopStack := ''
  else
    begin
      PopStack := StackList.Strings[StackList.Count-1];
      StackList.Delete(StackList.Count-1);
    end;
end;


procedure TThesaurusDlg.FormShow(Sender: TObject);
begin
  StackList.Clear;
  StackList.Sorted := FALSE;
  EntryList.Clear;
  EntryList.Sorted := FALSE;
  WordEdit.Text := RootWord;
  BtnBack.Enabled := FALSE;
  DesiredWord := RootWord;
  if CloseList then
    EntryList.Items := BaseAThs.GetThesaurusCloseList(ThesaurusDataPtr, RootWord)
  else
    if FullList then
      EntryList.Items := BaseAThs.GetThesaurusEntryFull(ThesaurusDataPtr, RootWord)
    else
      EntryList.Items := BaseAThs.GetThesaurusEntry(ThesaurusDataPtr, RootWord);
  EntryList.ItemIndex := 0;
end;

procedure TThesaurusDlg.EntryListDrawItem(Control: TWinControl;
  Index: Integer; Rect: TRect; State: TOwnerDrawState);
var S : string;
    OldColor : TColor;
    Color    : TColor;
    Offset   : integer;
  begin
  S := EntryList.Items.Strings[Index];
  OldColor := EntryList.Canvas.Font.Color;
  Color := OldColor;
  if s[1] in ['[','{'] then
    begin
      Offset := 2;
      Color := clGray;
      if S[1] = '[' then
        S := S + ']'
      else
        begin
          S := '';
          case Upcase(S[2]) of
           'V' : S := '{Verb}';
           'N' : S := '{Noun}';
           '*' : S := '{Informal}';
           'I' : S := '{Interjection}';
           'C' : S := '{Conjunction}';
           'A' : S := '{Adverb/Adjective}';
           'P' : begin
                   if Upcase(S[3]) = 'N' then
                     S := '{Pronoun}'
                   else
                     S := '{Preposition}';
                 end;
          end;
        end;
    end
  else
    begin
      Offset := 10;
      if not BaseAThs.HasEntry(ThesaurusDataPtr, S) then
        Color := clGray;
    end;
  EntryList.Canvas.FillRect(Rect);
  EntryList.Canvas.Font.Color := Color;
  EntryList.Canvas.TextOut(Rect.Left+Offset, Rect.Top, S);
  EntryList.Canvas.Font.Color := OldColor;
end;

procedure TThesaurusDlg.BtnBackClick(Sender: TObject);
begin
  if StackList.Count <> 0 then
    begin
      WordEdit.Text := PopStack;
      EntryList.Clear;
      if FullList then
        EntryList.Items := BaseAThs.GetThesaurusEntryFull(ThesaurusDataPtr, WordEdit.Text)
      else
        EntryList.Items := BaseAThs.GetThesaurusEntry(ThesaurusDataPtr, WordEdit.Text);
      EntryList.ItemIndex := 0;
      if StackList.Count = 0 then
        BtnBack.Enabled := FALSE;
    end;
end;

procedure TThesaurusDlg.Button1Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TThesaurusDlg.BtnRepaceClick(Sender: TObject);
var s : string;
begin
  S := EntryList.Items.Strings[EntryList.ItemIndex];
  if not (S[1] in ['[','{']) then
    DesiredWord := S
  else
    DesiredWord := WordEdit.Text;
  ModalResult := mrOK;
end;

procedure TThesaurusDlg.BtnTopClick(Sender: TObject);
begin
  BtnBack.Enabled := FALSE;
  StackList.Clear;
  WordEdit.Text := RootWord;
  if FullList then
    EntryList.Items := BaseAThs.GetThesaurusEntryFull(ThesaurusDataPtr, WordEdit.Text)
  else
    EntryList.Items := BaseAThs.GetThesaurusEntry(ThesaurusDataPtr, WordEdit.Text);
  EntryList.ItemIndex := 0;
end;

function TThesaurusDlg.Execute(ThesPtr : pointer; TheWord : string) : boolean;
begin
  ThesaurusDataPtr := ThesPtr;
  if not BaseAThs.HasEntry(ThesaurusDataPtr, TheWord) then
    begin
      if MessageDlg('No Entry Found'+#13+'Do you want a list of possible entries?',
                    mtConfirmation, [mbYES, mbCANCEL], -1) <> mrYes then
        begin
          Execute := FALSE;
          Exit;
        end;
      CloseList := TRUE;
    end
  else
    CloseList := FALSE;
  RootWord := TheWord;
  DesiredWord := TheWord;
  Execute := ShowModal = mrOK;
end;

procedure TThesaurusDlg.FormCreate(Sender: TObject);
begin
  StackList := TStringList.Create;
  FullList  := TRUE;
  CloseList := FALSE;
end;

procedure TThesaurusDlg.FormDestroy(Sender: TObject);
begin
  StackList.Free;
end;

procedure TThesaurusDlg.EntryListDblClick(Sender: TObject);
var S : string;
begin
  S := EntryList.Items.Strings[EntryList.ItemIndex];
  if S[1] in ['[','{'] then
    exit;
  if BaseAThs.HasEntry(ThesaurusDataPtr, S) then
    begin
      PushStack(WordEdit.Text);
      BtnBack.Enabled := TRUE;
      WordEdit.Text := S;
      EntryList.Clear;
      if FullList then
        EntryList.Items := BaseAThs.GetThesaurusEntryFull(ThesaurusDataPtr, S)
      else
        EntryList.Items := BaseAThs.GetThesaurusEntry(ThesaurusDataPtr, S);
      EntryList.ItemIndex := 0;
    end;
end;

end.
