unit dGrid;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TGridOptions = class(TForm)
    GridMarker: TRadioGroup;
    VisibleGrid: TCheckBox;
    GroupBox1: TGroupBox;
    XStep: TEdit;
    YStep: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure XStepKeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  GridOptions: TGridOptions;

implementation

{$R *.DFM}

procedure TGridOptions.XStepKeyPress(Sender: TObject; var Key: Char);
begin
     If Not ( Key in ['0'..'9'] ) Then Key := #0;
end;

procedure TGridOptions.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
Var
   X, Y : Integer;
begin
     Try
        X := StrToInt(XStep.Text);
        Y := StrToInt(YStep.Text);
        If X <= 0 Then
        Begin
             ShowMessage ( 'X increment must be greater than 0' );
             CanClose := False;
        End
        Else If Y <= 0 Then
        Begin
             ShowMessage ( 'Y increment must be greater than 0' );
             CanClose := False;
        End;
     Except
           ShowMessage ( 'Invalid increment entry - please re-enter' );
           CanClose := False;
     End;
end;

end.
