unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Mapi;

type
  TfrmMain = class(TForm)
    MapiSession1: TMapiSession;
    MapiMessage1: TMapiMessage;
    grpSession: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    edtName: TEdit;
    edtPwd: TEdit;
    chkLogonUI: TCheckBox;
    chkNewSession: TCheckBox;
    chkDownload: TCheckBox;
    btnConnect: TBitBtn;
    btnDisconnect: TBitBtn;
    grpMessage: TGroupBox;
    memoText: TMemo;
    memoFiles: TMemo;
    memoRecips: TMemo;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    btnSend: TBitBtn;
    btnRead: TBitBtn;
    Label6: TLabel;
    edtSubject: TEdit;
    chkShowAddressBook: TCheckBox;
    chkShowDialog: TCheckBox;
    chkReturnReceipt: TCheckBox;
    chkEnvelopeOnly: TCheckBox;
    chkUnreadOnly: TCheckBox;
    chkPeek: TCheckBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    procedure btnConnectClick(Sender: TObject);
    procedure btnDisconnectClick(Sender: TObject);
    procedure chkLogonUIClick(Sender: TObject);
    procedure chkNewSessionClick(Sender: TObject);
    procedure chkDownloadClick(Sender: TObject);
    procedure chkShowAddressBookClick(Sender: TObject);
    procedure chkShowDialogClick(Sender: TObject);
    procedure chkReturnReceiptClick(Sender: TObject);
    procedure chkEnvelopeOnlyClick(Sender: TObject);
    procedure chkUnreadOnlyClick(Sender: TObject);
    procedure chkPeekClick(Sender: TObject);
    procedure btnSendClick(Sender: TObject);
    procedure btnReadClick(Sender: TObject);
    procedure memoTextMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.btnConnectClick(Sender: TObject);
var
  MapiResult: TMAPIResults;
begin
  { Set properties }
  with MapiSession1 do
    begin
      MAPIName := edtName.Text;
      MAPIPwd := edtPwd.Text;
    end;

  { Try to open session }
  MapiResult := MapiSession1.OpenSession;

  if MapiResult = mrSuccess then
    begin
      btnDisconnect.Enabled := True;
      btnConnect.Enabled := False;
      btnSend.Enabled := True;
      btnRead.Enabled := True;
    end
  else
    ShowMessage('Couldn''t open session!');
end;

procedure TfrmMain.btnDisconnectClick(Sender: TObject);
var
  MapiResult: TMAPIResults;
begin
  { Try to close session }
  MapiResult := MapiSession1.CloseSession;

  if MapiResult = mrSuccess then
    begin
      btnDisconnect.Enabled := False;
      btnConnect.Enabled := True;
      btnSend.Enabled := False;
      btnRead.Enabled := False;
    end
  else
    ShowMessage('Could not close session!');
end;

procedure TfrmMain.chkLogonUIClick(Sender: TObject);
begin
  if chkLogonUI.Checked then
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions + [soLogonUI]
  else
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions - [soLogonUI];
end;

procedure TfrmMain.chkNewSessionClick(Sender: TObject);
begin
  if chkNewSession.Checked then
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions + [soNewSession]
  else
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions - [soNewSession];
end;

procedure TfrmMain.chkDownloadClick(Sender: TObject);
begin
  if chkDownload.Checked then
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions + [soDownloadMail]
  else
    MapiSession1.MAPIOptions := MapiSession1.MapiOptions - [soDownloadMail];
end;

procedure TfrmMain.chkShowAddressBookClick(Sender: TObject);
begin
  if chkShowAddressBook.Checked then
    MapiMessage1.SendOptions := MapiMessage1.SendOptions + [moShowAddressBook]
  else
    MapiMessage1.SendOptions := MapiMessage1.SendOptions - [moShowAddressBook];
end;

procedure TfrmMain.chkShowDialogClick(Sender: TObject);
begin
  if chkShowDialog.Checked then
    MapiMessage1.SendOptions := MapiMessage1.SendOptions + [moShowDialog]
  else
    MapiMessage1.SendOptions := MapiMessage1.SendOptions - [moShowDialog];
end;

procedure TfrmMain.chkReturnReceiptClick(Sender: TObject);
begin
  if chkReturnReceipt.Checked then
    MapiMessage1.SendOptions := MapiMessage1.SendOptions + [moReturnReceipt]
  else
    MapiMessage1.SendOptions := MapiMessage1.SendOptions - [moReturnReceipt];
end;

procedure TfrmMain.chkEnvelopeOnlyClick(Sender: TObject);
begin
  if chkEnvelopeOnly.Checked then
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions + [moEnvelopeOnly]
  else
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions - [moEnvelopeOnly];
end;

procedure TfrmMain.chkUnreadOnlyClick(Sender: TObject);
begin
  if chkUnreadOnly.Checked then
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions + [moUnreadOnly]
  else
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions - [moUnreadOnly];
end;

procedure TfrmMain.chkPeekClick(Sender: TObject);
begin
  if chkPeek.Checked then
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions + [moPeek]
  else
    MapiMessage1.ReadOptions := MapiMessage1.ReadOptions - [moPeek];
end;

procedure TfrmMain.btnSendClick(Sender: TObject);
var
  MapiResult: TMAPIResults;
begin
  { Load the message component }
  with MapiMessage1 do
    begin
      Files.Clear;
      Files.Addstrings(memoFiles.Lines);
      NoteText.Clear;
      NoteText.AddStrings(memoText.Lines);
      Recips.Clear;
      Recips.AddStrings(memoRecips.Lines);
      Session := MapiSession1.Session;
      Subject := edtSubject.Text;
    end;

  { Send the message }
  MapiResult := MapiMessage1.SendMail;
  if MapiResult <> mrSuccess then
    ShowMessage('Could not send mail!');
end;

procedure TfrmMain.btnReadClick(Sender: TObject);
var
  MapiResult: TMAPIResults;
begin
  { Read the mail }
  MapiMessage1.Session := MapiSession1.Session;
  MapiResult := MapiMessage1.GetMail;

  if MapiResult = mrNoMessages then
    ShowMessage('No more messages!');

  if MapiResult = mrSuccess then
    begin
      memoFiles.Clear;
      memoFiles.Lines.Addstrings(MapiMessage1.Files);
      memoText.Clear;
      memoText.Lines.Addstrings(MapiMessage1.NoteText);
      memoRecips.Clear;
      memoRecips.Lines.Addstrings(MapiMessage1.Recips);
      edtSubject.Text := MapiMessage1.Subject;
    end
  else
    ShowMessage('Could not read mail!');
end;

procedure TfrmMain.memoTextMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     If Button = mbRight then
       (Sender as TMemo).Clear;
end;

end.
