unit Testunt1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Mask, DBCtrls, DB, DBTables, DBLookup, Grids,
  DBGrids, IniFiles;

type
  TForm1 = class(TForm)
    datSvyQuestionsQ: TDataSource;
    dbqSvyQuestions: TQuery;
    dbqSvyQuestionsSurveyType: TIntegerField;
    dbqSvyQuestionsSurveyVersion: TFloatField;
    dbqSvyQuestionsQuestionEntryOrder: TSmallintField;
    dbqSvyQuestionsQuestionOnScreen: TStringField;
    dbqSvyQuestionsValidRespDesc: TStringField;
    gdSvyQuestions: TDBGrid;
    mmoQuestion: TMemo;
    btnClose: TButton;
    procedure gdSvyQuestionsDrawDataCell(Sender: TObject;
      const Rect: TRect; Field: TField; State: TGridDrawState);
    procedure FormActivate(Sender: TObject);
    procedure mmoQuestionClick(Sender: TObject);
    procedure btnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  { Redefine Grid class to expose ColWidths & RowHeights }
  type
     TOpenGrid = class(TDBGrid)
     public
       property ColWidths;
       property RowHeights;
     end;

var
  Form1: TForm1;
  bDebug : Boolean;

implementation

{$R *.DFM}


procedure PopupQuestion( const Rect: TRect; Field: TField );
var
  MyRect: TRect;
  iRowHeightP, iCellHeight: Integer;
begin
with Form1.mmoQuestion do
  begin
    {Compute height in pixels of one Grid Row }
    iRowHeightP := (Rect.Bottom - Rect.Top) - 3;
    { Make a non-const copy of Rect parameter }
    MyRect := Rect;
    { Stretch or shrink memo object to size of Grid Cell }
    BoundsRect := Rect;

    { Set text of memo cell - This will fill the "Lines" array. }
    WordWrap := True;
    Text := Field.Text;
    { Compute height in pixels of Wrapped Text }
    iCellHeight := iRowHeightP * Lines.Count;
    { Set the size of the Rectangle we will
      use to stretch the memo object }
    MyRect.Bottom := MyRect.Top + iCellHeight + 8;
    { Position the Rectangle so that it overlays the Grid Cell }
    with Form1.gdSvyQuestions do
      OffsetRect( MyRect, Left, Top );
    { Move and resize the Memo object and show it }
    BoundsRect := MyRect;
    Show;
  end;
end;

procedure TForm1.gdSvyQuestionsDrawDataCell(Sender: TObject;
  const Rect: TRect; Field: TField; State: TGridDrawState);
begin
  { Special things to do when we draw the Grid Cell with focus: }
  if (gdFocused in State) then
    begin
      { Hide the memo field }
      mmoQuestion.Hide;
      if (Field.DisplayLabel <> 'Question') then
        begin
        { if Question Column is NOT selected }
          { May do something in future };
        end
      else
        begin
        { if Question Column is selected, Show it }
          PopupQuestion( Rect, Field );
        end;
    end;
end;

procedure TForm1.FormActivate(Sender: TObject);
var
MyGrid: TOpenGrid;
MyRect: TRect;
begin
  { Make sure our overlay Memo object looks like the Grid Cell }
  mmoQuestion.Font := gdSvyQuestions.Font;
  { Set the color to something eye-catching (but not too gaudy) }
  mmoQuestion.Font.Color := clNavy;
  { Initialize Rectangle to current dimensions of Memo object }
  MyRect := mmoQuestion.BoundsRect;
  { We use a can opener to look at the private properties
    of the DBGrid object.  See the definition of TOpenGrid above.
    MyGrid gets to look at the ColWidths[] array. }
  MyGrid := TOpenGrid(gdSvyQuestions);
  { Stretch the Rectangle to fit exactly over
    the "Questions" column (ie. Column number 2) }
  MyRect.Right := MyRect.Left + MyGrid.ColWidths[2];
  { Resize the memo object using our "stretcher" Rect }
  mmoQuestion.BoundsRect := MyRect;
end;


procedure TForm1.mmoQuestionClick(Sender: TObject);
begin
   mmoQuestion.Hide;
end;


procedure TForm1.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
   ini : TIniFile;
   DataDir : String;
begin
  mmoQuestion.Hide;
  try
    { Create an INI object that opens "TEST.INI" in working dir }
    ini := TIniFile.Create('.\TEST.INI');
    DataDir := ini.ReadString('Test',
                            'DataDirectory',
                            'c:.\test\data' );
    dbqSvyQuestions.DatabaseName := DataDir;
    try
      dbqSvyQuestions.Open;
    except
      on EDataBaseError do begin
         MessageDlg('Could not open DB table - check TEST.INI file',
                    mtError,[mbOK], 0);
         dbqSvyQuestions.Close;
         Application.Terminate;
      end;
    end;
    datSvyQuestionsQ.DataSet  := dbqSvyQuestions;
    gdSvyQuestions.DataSource := datSvyQuestionsQ;
  finally
    { when we're done, this needs to get whacked }
    ini.Destroy;
  end;
end;

end.
