{$I OVC.INC}

{$B-} {Complete Boolean Evaluation}
{$G+} {286 Instructions}
{$I+} {Input/Output-Checking}
{$N+} {Numeric Coprocessor}
{$P+} {Open Parameters}
{$T-} {Typed @ Operator}
{$W-} {Windows Stack Frame}
{$X+} {Extended Syntax}

{$C MOVEABLE,DEMANDLOAD,DISCARDABLE}

{*********************************************************}
{*                   OVCREG.PAS 1.01                     *}
{*       Copyright (c) TurboPower Software Co 1995       *}
{*                 All rights reserved.                  *}
{*********************************************************}

{$R OVCREG.RES}

unit OvcReg;

interface

uses
  WinTypes, DsgnIntf, Classes;

type
  {property editor for the virtual listbox header string property}
  THeaderProperty = class(TCaptionProperty);

type
  {property editor for the timer pool}
  TOvcTimerPoolEditor = class(TDefaultEditor)
  protected
    procedure EditProperty(PropertyEditor : TPropertyEditor;
              var Continue, FreeEditor : Boolean);
      override;
  public
  end;


procedure Register;

implementation

uses
  {$IFDEF NVBUG} LibMain, {$ENDIF}
  WinProcs, SysUtils, Dialogs, Forms, Graphics,
  OvcEf,     {base entry field class--needed for sf, pf, nf, and ae}
  OvcEfPe,   {range property editor}
  OvcSf,     {simple field component}
  OvcSfPE,   {simple mask property editor form}
  OvcPf,     {picture field component}
  OvcPfPE,   {picture mask property editor form}
  OvcNf,     {numeric entry field component}
  OvcNfPE,   {numeric mask property editor}
  OvcAe,     {array editors}
  OvcAePe,   {range property editor}
  OvcVlb,    {virtual list box component}
  OvcNbk,    {notebook component}
  OvcNbkP0,  {property editor for the notebook pages}
  OvcCal,    {calendar component}
  OvcViewr,  {viewer and text file viewer components}
  OvcMeter,  {meter component}
  OvcSc,     {spin components}
  OvcScPE,   {spin components component editor}
  OvcTimer,  {timer pool}
  OvcRLbl,   {rotated label component}
  OvcEdit,   {editor and text editor components}
  OvcXfer,   {form data transfer component}
  OvcXfrC0,  {transfer component component editor}
  OvcFxFnt,  {fixed font class}
  OvcFxFPE,  {fixed font property editor}
  OvcFnPe,   {file name property editor}
  OvcBase, OvcCmd, OvcCmdP0, OvcData, OvcVer;  {all required}


{$I OVCTABS.INC}  {constant declarations for Delphi palette tab names}


{*** TOvcTimerPoolEditor ***}


procedure TOvcTimerPoolEditor.EditProperty(PropertyEditor : TPropertyEditor;
          var Continue, FreeEditor : Boolean);
var
  PropName : string;
begin
  PropName := PropertyEditor.GetName;
  if CompareText(PropName, 'ONALLTRIGGERS') = 0 then begin
    PropertyEditor.Edit;
    Continue := False;
  end;
end;


{*** component registration ***}

procedure Register;
begin
  {register property editor for the controller}
  RegisterPropertyEditor(
    TypeInfo(TOvcCommandProcessor), nil, '', TOvcCommandProcessorProperty);
  {register component editor for the controller}
  RegisterComponentEditor(TOvcController, TOvcControllerEditor);

  {register property editors for the entry fields}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcSimpleField, 'PictureMask', TSimpleMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureField, 'PictureMask', TPictureMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericField, 'PictureMask', TNumericMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcSimpleField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcSimpleField, 'RangeLo', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureField, 'RangeLo', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericField, 'RangeLo', OvcEfPe.TEfRangeProperty);

  {register property editors for the array editors}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcSimpleArrayEditor, 'PictureMask', TSimpleMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureArrayEditor, 'PictureMask', TPictureMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericArrayEditor, 'PictureMask', TNumericMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcSimpleArrayEditor, 'RangeHi', OvcAePe.TAeRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcSimpleArrayEditor, 'RangeLo', OvcAePe.TAeRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureArrayEditor, 'RangeHi', OvcAePe.TAeRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcPictureArrayEditor, 'RangeLo', OvcAePe.TAeRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericArrayEditor, 'RangeHi', OvcAePe.TAeRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNumericArrayEditor, 'RangeLo', OvcAePe.TAeRangeProperty);

  {register property editor for the header of the virtual list box}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcVirtualListBox, 'Header', THeaderProperty);

  {register property editors and component editor for the notebook component}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcNotebook, 'ActivePageName', TOvcTabPageNameProperty);
  RegisterPropertyEditor(
    TypeInfo(TStrings), TOvcNotebook, 'Pages', TOvcTabPageListProperty);
  RegisterComponentEditor(TOvcNotebook, TOvcNotebookEditor);

  {register component editor for the timer pool component}
  RegisterComponentEditor(TOvcTimerPool, TOvcTimerPoolEditor);

  {register component editor for the spinner components}
  RegisterComponentEditor(TOvcSpinner, TOvcSpinnerEditor);
  RegisterComponentEditor(TOvcFourWaySpinner, TOvcSpinnerEditor);
  RegisterComponentEditor(TOvcStarSpinner, TOvcSpinnerEditor);

  {register property editors for the fixed font class}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcFixedFont, 'Name', TOvcFixFontNameProperty);
  RegisterPropertyEditor(
    TypeInfo(TOvcFixedFont), nil, '', TOvcFixFontProperty);

  {register component editor for the transfer component}
  RegisterComponentEditor(TOvcTransfer, TOvcTransferEditor);

  {register property editor and viewer for FileName properties}
  RegisterPropertyEditor(
    TypeInfo(string), TOvcTextFileEditor, 'FileName', TFileNameProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcFileViewer, 'FileName', TFileNameProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcTextFileViewer, 'FileName', TFileNameProperty);

  {register our components}
  RegisterComponents(OrpheusTabName,
    [TOvcSimpleField,
     TOvcPictureField,
     TOvcNumericField,
     TOvcSimpleArrayEditor,
     TOvcPictureArrayEditor,
     TOvcNumericArrayEditor,
     TOvcVirtualListbox,
     TOvcEditor,
     TOvcTextFileEditor,
     TOvcFileViewer,
     TOvcTextFileViewer,
     TOvcNotebook,
     TOvcTimerPool,
     TOvcRotatedLabel,
     TOvcCalendar,
     TOvcMeter,
     TOvcSpinner,
     TOvcFourWaySpinner,
     TOvcStarSpinner,
     TOvcTransfer,
     TOvcController
    ]);

{$IFDEF NVBUG}
  {assign pointer to CompLib for use in OvcBase}
  OvcBase.ICompLib := LibMain.CompLib;
{$ENDIF}
end;

end.
