{$B-} {Complete Boolean Evaluation}
{$G+} {286 Instructions}
{$I+} {Input/Output-Checking}
{$N+} {Numeric Coprocessor}
{$P+} {Open Parameters}
{$T-} {Typed @ Operator}
{$W-} {Windows Stack Frame}
{$X+} {Extended Syntax}

{$C MOVEABLE,DEMANDLOAD,DISCARDABLE}

{*********************************************************}
{*                  OVCREGDB.PAS 1.01                    *}
{*       Copyright (c) TurboPower Software Co 1995       *}
{*                 All rights reserved.                  *}
{*********************************************************}

unit OvcRegDb;

interface

uses
  WinTypes, DsgnIntf, Classes;

procedure Register;

implementation

uses
  OvcVer,
  OvcEfPe,   {range property editor}
  OvcSfPE,   {simple mask property editor form}
  OvcPfPE,   {picture mask property editor form}
  OvcNfPE,   {numeric mask property editor}
  OvcDbSf,   {data aware simple field}
  OvcDbPf,   {data aware picture field}
  OvcDbNf,   {data aware numeric field}
  OvcDbEd;   {data aware editor}


{$I OVCTABS.INC}  {constant declarations for Delphi palette tab names}


{*** component registration ***}

procedure Register;
begin
  {register property editors for the data aware entry fields}
  RegisterPropertyEditor(
    TypeInfo(Char), TOvcDbSimpleField, 'PictureMask', TSimpleMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbPictureField, 'PictureMask', TPictureMaskProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbNumericField, 'PictureMask', TNumericMaskProperty);

  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbSimpleField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbSimpleField, 'RangeLo', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbPictureField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbPictureField, 'RangeLo', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbNumericField, 'RangeHi', OvcEfPe.TEfRangeProperty);
  RegisterPropertyEditor(
    TypeInfo(string), TOvcDbNumericField, 'RangeLo', OvcEfPe.TEfRangeProperty);

  {register DB components}
  RegisterComponents(OrpheusDataAwareTabName,
    [TOvcDbSimpleField,
     TOvcDbPictureField,
     TOvcDbNumericField,
     TOvcDbEditor
    ]);
end;

end.
