unit VAEdit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type

  NumberType = Double; {<-----Change If Needed!}

  ValidateEdit = class(TEdit)
private
 { Private declarations }
protected
  FGreaterThanOrEqualTo: Boolean;
  FLessThanOrEqualTo: Boolean;
  FGreaterNumber: NumberType;
  FLessNumber: NumberType;
  NumbersAfter: Byte;
  ValidateChar: set of Char;
 { Protected declarations }
  Procedure SetGreaterThanOrEqualTo(Value: Boolean);
  Procedure SetLessThanOrEqualTo(Value:Boolean);
  Procedure SetGreaterNumber(Value: NumberType);
  Procedure SetLessNumber(Value: NumberType);
public
 { Public declarations }
  Constructor Create(AOwner:TComponent); override;
  procedure KeyPress(var Key: Char); override;
  Procedure DoExit; override;
published
 { Published declarations }
  Property GreaterNumber: NumberType
                   read FGreaterNumber
                   Write SetGreaterNumber;
  Property LessNumber: NumberType
                   read FLessNumber
                   Write SetLessNumber;
  Property GreaterOrEqual: Boolean read FGreaterThanOrEqualTo
                                   write SetGreaterThanOrEqualTo;
  Property LessOrEqual: Boolean read FLessThanOrEqualTo
                                write SetLessThanOrEqualTo;
    end;

procedure Register;

implementation

Constructor ValidateEdit.Create(AOwner:TComponent);
  begin
    inherited Create(AOwner);
    FLessThanOrEqualTo := True;
    FGreaterThanOrEqualTo := True;
    FGreaterNumber := 0.0;
    FLessNumber := 0.0;
    NumbersAfter := 2; {<-----Change If Needed!}
    ValidateChar := ['0'..'9','.','-','+','e','E']; {<-----Change If Needed!}
  end;


Procedure ValidateEdit.SetGreaterNumber(Value: NumberType);
 Begin
    FGreaterNumber := Value;
     if FLessNumber < FGreaterNumber then
       begin
        FLessNumber := 99999.9999;
        FGreaterNumber := -99999.999;
       end;
end;

Procedure ValidateEdit.SetLessNumber(Value: NumberType);
 Begin
    FLessNumber := Value;
     if FLessNumber < FGreaterNumber then
       begin
        FLessNumber := 99999.9999;
        FGreaterNumber := -99999.999;
       end;
 end;

Procedure ValidateEdit.SetGreaterThanOrEqualTo(Value:Boolean);
Begin
  if Value<>FGreaterThanOrEqualTo then
    FGreaterThanOrEqualTo:=Value;
end;

Procedure ValidateEdit.SetLessThanOrEqualTo(Value:Boolean);
Begin
  if Value<>FLessThanOrEqualTo then
    FLessThanOrEqualTo:=Value;
end;

procedure ValidateEdit.DoExit;
var code: integer;
    number: NumberType;
    LessString: String;
    GreaterString: String;
begin
  inherited DoExit;
if Text = '' then
     Begin
       MessageDlg(' Field is required! ',mtWarning, [mbOK],0);
       SetFocus;
       exit;
     end;


     str(FLessNumber:1:NumbersAfter, LessString);
     str(FGreaterNumber:1:NumbersAfter, GreaterString);
     val(Text, Number,code);

if code <> 0 then
   Begin
     MessageDlg(' Incorrect Numeric Format! ', mtWarning, [mbOK],0);
     SetFocus;
   end
 else
   begin
     if ((FLessThanOrEqualTo) and (FGreaterThanOrEqualTo)) then
      begin
       If ((Number > FLessNumber) or (Number < FGreaterNumber)) then
           begin
            MessageDlg(' Must be > or = to '+ GreaterString +
                   ' and < or = to ' + LessString, mtWarning, [mbOK], 0);
            SetFocus;
            Exit;
           end;
      end;
     if ((Not(FLessThanOrEqualTo) and (FGreaterThanOrEqualTo))) then
      begin
       If ((Number >= FLessNumber) or (Number < FGreaterNumber)) then
          begin
           MessageDlg(' Must be > or = '+ GreaterString +
                  ' and < ' + LessString, mtWarning, [mbOK], 0);
           SetFocus;
           Exit;
          end;
      end;
    if ((Not(FLessThanOrEqualTo)) and (Not(FGreaterThanOrEqualTo))) then
      begin
       If ((Number >= FLessNumber) or (Number <= FGreaterNumber)) then
          begin
           MessageDlg(' Must be > '+ GreaterString +
                  ' and < ' + LessString, mtWarning, [mbOK], 0);
           SetFocus;
           Exit;
     end;
    end;
    If ((FLessThanOrEqualTo) and (Not(FGreaterThanOrEqualTo))) then
      begin
       If ((Number > FLessNumber) or (Number <= FGreaterNumber)) then
          begin
           MessageDlg(' Must be > '+ GreaterString +
                  ' and < or = to ' + LessString, mtWarning, [mbOK], 0);
           SetFocus;
           Exit;
          end;
      end;

  end;

  end ;

 procedure ValidateEdit.KeyPress(Var Key: Char);
 begin
  if (NOT (Key in ValidateChar)) and (Key<>#08) then  Key:=#0;
  inherited KeyPress(Key);
 end;

procedure Register;
begin
  RegisterComponents('Additional', [ValidateEdit]);
end;

end.
