# This script will be called from the 'Setup' utility
#

use Carp;
eval "use Calendar::CSA";

if ($@)
{
    $err = $@;

    if ($err =~ /can\'t open file/)
    {
	print qq|
You do not appear to have CDE installed on your system.
Please verify that '/usr/dt/lib/libcsa.so.0' exists and
that '/usr/dt/lib' is in your LD_LIBRARY_PATH

SyncCM will not be able to run until this is fixed.
|;
	croak("FAIL");
    }

    if ($err =~ /version\s*\S+\s*not found/)
    {
	print qq|
Your CDE libraries appear to be obsolete.  Please request
that your system administrator upgrade your CDE libraries
to at least CDE 1.1 FCS.

SyncCM will not be able to run until this is fixed.
|;
	croak("FAIL");
    }

    
    print qq|
	
	There is a problem with the Calendar::CSA module that Setup
	cannot diagnose.  Please file a bug using the Feedback menu
	in PilotManager.

        SyncCM will not be able to run until this is fixed.

	    \n|;
    croak("FAIL");
}

print qq|
CDE is installed properly on your system, so SyncCM will run.
Now let's test your calendar server and make sure that it is
running the correct release of the software.  We'll also make
sure that your calendar is in the correct format while we're
at it.

Please enter a calendar address (e.g, "bharat\@shadow")
that you would normally use with SyncCM.  This calendar will 
not be modified in any way.  
|;

while (1)
{
print qq|
Enter a blank line to end this test.
Calendar: |;

    chomp($caladdr = <STDIN>);

    last unless $caladdr;

    ($user, $host) = ($caladdr =~ /(.*)@(.*)/);

    print "Connecting to ${caladdr}...";
    
    eval
    {
	$session = Calendar::CSA::logon("",
					{
					    user_name => $caladdr,
					    user_type => 'INDIVIDUAL',
					    calendar_address => $caladdr
					    } );
    };

    if ($@)
    {
	$@ =~ s/ at .*//;

	print qq|ERROR!
$@
|;
	next;
    }

    print "connected.\n";

    eval
    {
	$session->short_entry_names(1);
	$session->unix_times(1);

	%attrs = $session->read_calendar_attributes;

	if ($attrs{'Server Version'}->{'value'} != 5)
	{
	    print qq|
Your calendar server ($host) is running an out-of-date version
of the calendar server software.  Please upgrade it to CDE 1.1 FCS
|;	
	    next;
	}

	if ($attrs{'Data Version'}->{'value'} != 4)
	{
	    print qq|
Your calendar (on $host) is in an out-of-date data format.
Please upgrade it to the new format using 'sdtcm_convert'.
If you have difficulties, please request that your system
administrator assist you.
|;
	    next;
	}

	print qq|
Congratulations, your calendar and calendar server are up to
date.  You should be able to use SyncCM with no problems!
|;
    };

    if ($@)
    {
	$@ =~ s/at lib.*//;

	if ($@ =~ /NO AUTHORITY/)
	{
	    print qq|
You do not have authority to examine the attributes for 
$caladdr.  Without examining the calendar's attributes, it is
impossible to tell whether or not it will work with SyncCM.  SyncCM
will not take any chances and will not allow you to synchronize this
calendar.  Please contact your system adminstrator and request that
they give you full permissions for this calendar.

|;
	}
    }
}

1;
