/*
ͻ
 What's it called: EPMGCC  V3.00                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains default constants for external commands 
                   and command parameters. It is included in GCC.E.           
                                                                              
 Who and When:     B. Bablok 12/93 - 07/96                                    
                                                                              
ͼ
*/

CONST
/*
Ŀ
  Constants which cannot be changed at runtime.                               

*/
   GCC_MENU_ALWAYS_ON = 1                  -- change to 0
/*
Ŀ
  Constants which can be changed using an external e-macro (see the samples   
  and documentation for details).                                             
  See the OS2-reference for the meaning of /c, /n and /win.                   

*/
   GCC_EDIT_COMMAND   = 'start /c /win epro'  -- change to 'EDIT' if you don't
                                              -- want to use epro.cmd

   GCC_COMP_COMMAND   = 'start /n /win gcc'   -- commands to invoke the compiler,
   GCC_BUILD_COMMAND  = 'start /n /win make'  -- the make utility and
   GCC_DEBUG_COMMAND  = 'start /n /win gdb'   -- your favorite debugger

   GCC_PARSER_MODULE  = 'gccparse'            -- module containing error-parser
   GCC_WANT_TRANSLATE = 1                     -- translate \ to / in filenames

/*
Ŀ
  Templates for compile/build options. Templates with '_D_' in the name are   
  used if debug-mode is turned on, otherwise the '_P_' templates are used.    
  Replacement rules (file is either the current file or the makefile):        
    %*   fully qualified filename                                             
    %**D drive letter and colon                                               
    %**P path, including drive and trailing '\'                               
    %**F filename, including extension                                        
    %**N filename without extension                                           
    %**E extension                                                            
  These templates can be changed at runtime (using the setup-macros).         

*/
   GCC_D_COMPILE_OPTIONS = '-c -g2 -Wall %*'
   GCC_P_COMPILE_OPTIONS = '-O2 -o %**P%**N.exe %*'
   GCC_D_BUILD_OPTIONS   = '-k -f %* MODE=D'
   GCC_P_BUILD_OPTIONS   = '-k -f %* MODE=P'
/*
Ŀ
  Constants which define the startup values of autosave, debug, verbose,      
  auto-err-remove and save-settings mode. These toggles can be changed        
  runtime.                                                                    

*/
   GCC_AUTOSAVE_FILE = 1       -- save file / all files before compile or build
   GCC_DEBUG_MODE    = 1       -- use debug-templates for compile / build
   GCC_VERBOSE_MODE  = 0       -- don't show commands in the message area
   GCC_REMOVE_MODE   = 1       -- automatically remove .err files
   GCC_SETTINGS_MODE = 1       -- save settings at exit
