/* index.c
   processing for full index search support */

     /*---------------------------------------------------------------*/
     /* Moog           version 0.0     27 October 1992                */
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /*                                                               */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /*                                                               */
     /* Martin Hamilton,  Loughborough University of Technology       */
     /*                   Department of Computer Studies              */
     /*                                                               */
     /* Allan Tuchman,    University of Illinois at Urbana-Champaign  */
     /*                   Computing Services Office                   */
     /*                                                               */
     /* Jonathan Goldman, WAIS project                                */
     /*                   Thinking Machines Corporation               */
     /*                                                               */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/SelectioB.h>

#include "index.h"
#include "gui.h"

#define INDEX_SHELL_TITLE	"Index Search"


static	Widget		topLevel;
static	Widget		indexDialog,
			queryText, doIndexButton,
			indexLabel;
static	Boolean		indexPanelCreated = False;
static	XtPointer	savedItem;



/* helpProc
   provide help for a index search session */

static void
helpProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	showHelp("index help");
}


/* doIndexProc
   submit a query to an index search */

static void
doIndexProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	char		*string, *s;
	int		length;
	Boolean		inPlace;

	XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)callData)->value, 
			XmSTRING_DEFAULT_CHARSET, &s);
			
	length = strlen(s);

	string = XtMalloc(length + 1);
	strncpy (string, s, length);
	string[length] = '\0';

	if (strlen(string) == 0) {
		showError("Enter a query string.");
	} else {
		/* do Index */
		XtUnmanageChild(indexDialog);

		processIndexSelection(clientData, string);
	}

}


/* cancelProc
   cancel a index search session */

static void
cancelProc(w, clientData, callData)
Widget		w;
XtPointer	clientData, callData;
{
	XtUnmanageChild(indexDialog);
}


/* IndexOk
   accept the "do Index" action from a keyboard <cr> instead of the
   "do Index" button.  The <cr> translation is defined elsewhere.
   Capitalized name is for X action proc convention. */

static void
IndexOk(w, event, parms, nparms)
Widget          w;
XEvent          *event;
String          *parms;
Cardinal        *nparms;
{
        doIndexProc(w, savedItem, NULL);
        return;
}


/* displayIndexPanel
   display the panel for index search queries */

void
displayIndexPanel(clientData, title)
XtPointer	clientData;
char		*title;
{
	char		titleString[128];

	sprintf (titleString, "Search of:  %.60s\n", title);

	XtVaSetValues(indexDialog,
		      XmNselectionLabelString,
		      XmStringCreateLtoR(titleString,XmSTRING_DEFAULT_CHARSET),
		      NULL);

	XtAddCallback(indexDialog, XmNokCallback, doIndexProc, clientData);
	savedItem = clientData;

	XtManageChild(indexDialog);

	return;
}


/* makeIndexPanel
   create the X panel for Index Search queries */

void
makeIndexPanel(top)
Widget	top;
{
	Arg		args[10];
	Cardinal	n;
	Widget		cancelButton, helpButton;

	static XtActionsRec     indexActionsTable[] = {
					{ "indexok", (XtActionProc) IndexOk }
					};

	if (indexPanelCreated) return;

	topLevel = top;

	/* create Index Search shell */

	n=0;
	XtSetArg(args[n], XtNtitle, INDEX_SHELL_TITLE);  n++;

	indexDialog = XmCreatePromptDialog(topLevel, "indexDialog",
					    args, n);

	XtAddCallback(indexDialog, XmNcancelCallback, cancelProc, NULL);
	XtAddCallback(indexDialog, XmNhelpCallback, helpProc, NULL);

	XtAddActions(indexActionsTable, XtNumber(indexActionsTable));

	indexPanelCreated = True;
}
