/* save.c
   make the file save dialog popup, and manage it. */

     /*---------------------------------------------------------------*/
     /* Moog           version 0.0     27 October 1992                */
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /*                                                               */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /*                                                               */
     /* Martin Hamilton,  Loughborough University of Technology       */
     /*                   Department of Computer Studies              */
     /*                                                               */
     /* Allan Tuchman,    University of Illinois at Urbana-Champaign  */
     /*                   Computing Services Office                   */
     /*                                                               */
     /* Jonathan Goldman, WAIS project                                */
     /*                   Thinking Machines Corporation               */
     /*                                                               */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>
#include <ctype.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>

#include "gopher.h"
#include "resources.h"
#include "xglobals.h"
#include "gui.h"


static	char	 fileToSave[PATH_NAME_LEN];

static Widget	topLevel;
Widget		saveDialog;


/* saveOkProc
   accept file name and complete the save command */

void
saveOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	int	c;
	char	*oldFile = fileToSave;
	char	*newFile = NULL, *p;
	FILE	*inFP, *outFP;


	XmStringGetLtoR(((XmSelectionBoxCallbackStruct *)call_data)->value,
			XmSTRING_DEFAULT_CHARSET, &newFile);

	XtUnmanageChild(saveDialog);

	for (p=newFile; isgraph(*p); p++) ;
	if (*p != NULL) {
		/* truncated at first non-printable character */
		*p = NULL;
	} 
	if (*newFile == NULL) {
		showError(
"Warning:\nA legal file name was not provided, so text will NOT be saved");
		return;
	}

	if ((inFP = fopen(oldFile, "r")) == NULL) {
		showError(
"The text cannot be saved, gopher's temporary file cannot be opened");
		return;
	}

	if ((outFP = fopen(newFile, "w")) == NULL) {
		showError(
"The text cannot be saved, the file name you entered cannot be opened");
		return;
	}

	while ( (c = fgetc(inFP)) != EOF )
		fputc((char) c, outFP);

	fclose(inFP);
	fclose(outFP);

	return;
}


/* SaveOk
   accept the OK action from a keyboard <cr> instead of the OK button.
   The <cr> translation is defined elsewhere.
   Capitalized name is for X action proc convention. */

void
SaveOk(w, event, parms, nparms)
Widget		w;
XEvent		*event;
String		*parms;
Cardinal	*nparms;
{
	saveOkProc(w, NULL, NULL);
	return;
}


/* saveCancelProc
   reject file name and do not process the save command */

void
saveCancelProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	char	*oldFile = (char *) client_data;

	XtUnmanageChild(saveDialog);
}


/* makeSaveDialog
   create popup dialog for saving files */

void
makeSaveDialog(top)
Widget	top;
{
	Widget		okButton, cancelButton;
	Arg		args[10];
	Cardinal	n = 0;
	static XtActionsRec	saveActionsTable[] = {
					{ "saveok", (XtActionProc) SaveOk }
					};
	topLevel = top;

	n = 0;
	XtSetArg(args[n], XtNtitle, "Save text to file...");  n++;

	saveDialog = XmCreatePromptDialog(topLevel, "saveDialog", args, n);

	XtUnmanageChild(XmSelectionBoxGetChild(saveDialog,
					      XmDIALOG_HELP_BUTTON));

        XtAddCallback(saveDialog, XmNokCallback, saveOkProc, NULL);
        XtAddCallback(saveDialog, XmNcancelCallback, saveCancelProc, NULL);

	XtAddActions(saveActionsTable, XtNumber(saveActionsTable));
}


/* saveRequest
   enable popup dialog for saving files */

void
saveRequest(textShell, gopherFileName)
Widget	textShell;
char	*gopherFileName;
{
	Arg		args[3];
	Cardinal	n = 0;
	Position	x, y;
	Dimension	w, h;

	strcpy (fileToSave, gopherFileName);

	/* should give name of subject that is being saved */

	XtVaSetValues(saveDialog,
		      XtNlabel, "Save text to file ...",
		      XtNtransientFor, textShell,
		      NULL);

	XtManageChild(saveDialog);

	return;
}
