/* xgopher.c
   Xgopher main program */

     /*---------------------------------------------------------------*/
     /* Moog           version 0.0     27 October 1992                */
     /* Xgopher        version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /*                                                               */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /*                                                               */
     /* Martin Hamilton,  Loughborough University of Technology       */
     /*                   Department of Computer Studies              */
     /*                                                               */
     /* Allan Tuchman,    University of Illinois at Urbana-Champaign  */
     /*                   Computing Services Office                   */
     /*                                                               */
     /* Jonathan Goldman, WAIS project                                */
     /*                   Thinking Machines Corporation               */
     /*                                                               */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include <stdio.h>

#include <string.h>

#ifdef sun
#include <strings.h>
#endif

#include "conf.h"
#include "gui.h"
#include "options.h"
#include "resources.h"
#include "util.h"

#define GLOBALS
#include "globals.h"
#undef GLOBALS

BOOLEAN	getOptions(
#ifdef PROTO
	int,
	char **
#endif
);


/* noOptions
   Cannot find the resources file... help the user a bit */

void
noOptions()
{
	fprintf (stderr,
		"The %s Application Resources file is not available.\n",
		GOPHER_CLASS);
	fprintf (stderr,
		"The file \'%s\' should be stored in the directory ",
		GOPHER_CLASS);
	fprintf (stderr, "/usr/lib/X11/app-defaults.\n");
	fprintf (stderr, "It can also be located in your own ");
	fprintf (stderr, "app-defaults directory, or the contents\n");
	fprintf (stderr, "can be copied to one of your other ");
	fprintf (stderr, "X windows resources files.\n");
	fprintf (stderr, "\n%s cannot continue without this file.\n",
		GOPHER);
}

main(argc, argv)
int	argc;
char	**argv;
{
	char			*p;
	gopherItemP		mainItem;
	char			errorString[MESSAGE_STRING_LEN];

	/* save last component of path name */

	if ((p = rindex(argv[0], '/')) == 0) p = argv[0];
	strcpy(gopherName, p);

	/* initialize the Graphical User Interface, the X window system */

	if (! initGUI(&argc, argv)) {
		noOptions();
		exit(1);
	}

	mainItem = makeItem(A_DIRECTORY,
			    appResources->mainTitle, "",
			    appResources->rootServer, appResources->rootPort);
			

	if (! processSelection(mainItem)) {
		sprintf(errorString,
		"Unrecoverable error:\ncannot access the main %s directory", 
								GOPHER);
		showFatalError(errorString);
	};

	if (appResources->markRoot) markCurrentDirectory();

	doUserRequests();
}
