#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "ax25.h"
#include "ip.h"
#include "timer.h"

static struct lq *al_lookup __ARGS((struct iface *ifp,char *addr));
static struct lq *al_create __ARGS((struct iface *ifp,char *addr));

struct lq *Lq[NHASH];

#ifdef	notdef
/* Send link quality reports to interface */
void
genrpt(ifp)
struct iface *ifp;
{
	struct mbuf *bp;
	register char *cp;
	int i;
	struct lq *lp;
	int maxentries,nentries;

	maxentries = (Paclen - LQHDR) / LQENTRY;
	if((bp = alloc_mbuf(Paclen)) == NULLBUF)
		return;
	cp = bp->data;
	nentries = 0;

	/* Build and emit header */
	cp = putlqhdr(cp,LINKVERS,Ip_addr);

	/* First entry is for ourselves. Since we're examining the Axsent
	 * variable before we've sent this frame, add one to it so it'll
	 * match the receiver's count after he gets this frame.
	 */
	cp = putlqentry(cp,ifp->hwaddr,Axsent+1);
	nentries++;

	/* Now add entries from table */
	for(i=0;i<NHASH;i++){
		for(lp = lq[i];lp != NULLLQ;lp = lp->next){
			cp = putlqentry(cp,&lp->addr,lp->currxcnt);
			if(++nentries >= MAXENTRIES){
				/* Flush */
				bp->cnt = nentries*LQENTRY + LQHDR;
				ax_output(ifp,Ax25_bdcst,ifp->hwaddr,PID_LQ,bp);
				if((bp = alloc_mbuf(Paclen)) == NULLBUF)
					return;
				cp = bp->data;
			}
		}
	}
	if(nentries > 0){
		bp->cnt = nentries*LQENTRY + LQHDR;
		ax_output(ifp,Ax25_bdcst,ifp->hwaddr,LQPID,bp);
	} else {
		free_p(bp);
	}
}

/* Pull the header off a link quality packet */
void
getlqhdr(hp,bpp)
struct lqhdr *hp;
struct mbuf **bpp;
{
	hp->version = pull16(bpp);
	hp->ip_addr = pull32(bpp);
}

/* Put a header on a link quality packet.
 * Return pointer to buffer immediately following header
 */
char *
putlqhdr(cp,version,ip_addr)
register char *cp;
int16 version;
int32 ip_addr;
{
	cp = put16(cp,version);
	return put32(cp,ip_addr);
}

/* Pull an entry off a link quality packet */
void
getlqentry(ep,bpp)
struct lqentry *ep;
struct mbuf **bpp;
{
	pullup(bpp,ep->addr,AXALEN);
	ep->count = pull32(bpp);
}

/* Put an entry on a link quality packet
 * Return pointer to buffer immediately following header
 */
char *
putlqentry(cp,addr,count)
char *cp;
char *addr;
int32 count;
{
	memcpy(cp,addr,AXALEN);
	cp += AXALEN;
	return put32(cp,count);
}
#endif

/* Log the address of an incoming packet */
void
logaddr(ifp,addr)
struct iface *ifp;
char *addr;
{
	register struct lq *lp;

	if(addreq(addr,ifp->hwaddr))
		return;	/* Don't log our own packets if we hear them */

	if((lp = al_lookup(ifp,addr)) == NULLLQ
	 && (lp = al_create(ifp,addr)) == NULLLQ)
		return;
	lp->currxcnt++;
	lp->time = Clock;
}
static struct lq *
al_lookup(ifp,addr)
struct iface *ifp;
char *addr;
{
	register struct lq *lp;

	for(lp = Lq[ax25hash(addr)];lp != NULLLQ;lp = lp->next){
		if(addreq(lp->addr,addr) && lp->iface == ifp){
			return lp;
		}
	}
	return NULLLQ;
}
/* Create a new entry in the AX.25 link table */
static struct lq *
al_create(ifp,addr)
struct iface *ifp;
char *addr;
{
	register struct lq *lp;
	int16 hashval;

	lp = (struct lq *)callocw(1,sizeof(struct lq));

	lp->addr = mallocw(AXALEN);
	memcpy(lp->addr,addr,AXALEN);
	hashval = ax25hash(addr);
	lp->next = Lq[hashval];
	if(lp->next != NULLLQ)
		lp->next->prev = lp;
	Lq[hashval] = lp;
	lp->iface = ifp;

	return lp;
}
