#ifndef BM_NONE
/* bm.h -- definitons for bm.c that aren't included elsewhere */

/* types of config file lines that we know how to handle */
#define BM_NONE		0
#define BM_MAXLET	1
#define BM_SMTP		2
#define BM_HOST		3
#define BM_USER		4
#define BM_EDIT		6
#define BM_NAME		7
#define BM_REPLY	8
#define BM_MBOX		9
#define BM_RECORD	10
#define BM_SCREEN	11
#define BM_FOLDER	12
#define BM_MQUEUE	13
#define BM_ALIAS	14

/* Header types */
#define	NOHEADER 	0
#define	FROM		1
#define	TO		2
#define	DATE		3
#define	MSGID		4
#define	SUBJECT		5
#define	RECEIVED	6
#define	SENDER		8
#define	REPLYTO		9
#define	UNKNOWN		10
#define STATUS		11

#ifdef UNIX
#define	RUNCOM	".bmrc"		/* config file */
#else
#define	RUNCOM	"/bm.rc"		/* config file */
#endif

/* number of columns and lines on a standard display, e.g. vt100 */
#define	MAXCOL		80
#define MAXLIN		24

/* message status */
#define	BM_DELETE	1
#define	BM_READ		2

#define BM_NLET		300	/* default size of letter array */

#define SLINELEN	64
#define LINELEN		256

/* a mailbox list entry */
struct let {
	long	start;
	long	size;
	int	status;
};

/* address structure */
struct bm_addr {
	struct addr *next;
	char *user;
	char *host;
	int sent;
};
#define	NULLBMADDR (struct bm_addr *)0	/* Null address */

/* token used for a string and its token */
struct token {
	char *str;
	char type;
};

/* global definitions */
extern char
	*Username,		/* name of this user from rc file */
	*Fullname,		/* name of this user from rc file */
	*Replyto,		/* return address fro reply-to */
	*Editor,		/* user's favorite editor program */
	*Savebox,		/* user's mbox for the s command */
	*Record,		/* place to store a copy of snet mail for you */
	*Folder;	/* directory used for save and write commands */

extern unsigned Maxlet;		/* max messages */
extern char *fgets();

void scanmail __ARGS((struct mbx *m));
int dolistnotes __ARGS((int argc,char *argv[],void *p));
int dodelmsg __ARGS((int argc,char *argv[],void *p));
int doreadmsg __ARGS((int argc,char *argv[],void *p));
int doreadnext __ARGS((int argc,char *argv[],void *p));
int closenotes __ARGS((struct mbx *m));
int isnewprivmail __ARGS((struct mbx *m));
    
#endif  /* BM_NONE */
