#define	BASE 0x380
#define	CTL 	(BASE+0)
#define	DATA	(BASE+1)

#define	KEYUP	105	/* Keyup delay: 105 bytes = 15 ms */
#define	TAIL	3	/* TX release delay */

char isat;

#include <stdio.h>
#include <dos.h>
#include "8530.h"

void send_buf __ARGS((char *buf,unsigned int n));
void txon __ARGS((void));
void txoff __ARGS((void));

#ifndef	foo
char buf[7000] = "Testing de KA9Q, Warren, NJ, using 56kbps MSK modem by WA4DSY";
#else
char buf[7000];
#endif

main()
{
	register int i;

	/* Reset and Initialize 8530 channel B */
	write_scc(CTL,R9,FHWRES);
	write_scc(CTL,R4,X1CLK|SDLC|SYNC_ENAB);
	write_scc(CTL,R1,0); /* Disable interrupts */
	write_scc(CTL,R3,Rx8|RxCRC_ENAB|RxENABLE);
	write_scc(CTL,R5,DTR|Tx8|TxENAB|TxCRC_ENAB);
	write_scc(CTL,R7,FLAG);
	write_scc(CTL,R9,0);	/* Interrupt bits off */
	write_scc(CTL,R10,CRCPS|NRZ);	/* NRZ mode */
	write_scc(CTL,R11,RCTRxCP|TCRTxCP); /* RxCLK = TRxCLK, TxCLK = RTxCLK */
	write_scc(CTL,R0,RES_EOM_L);	/* Clear end-of-message flag */

	txon();
	for(i=0;i<7;i++)
		send_buf(buf,sizeof(buf));
	txoff();
	return 0;
}
/* Transmit a buffer. The transmitter must already be on. */
void
send_buf(buf,n)
register char *buf;
register unsigned int n;
{
	write_scc(CTL,R0,RES_Tx_CRC);	/* Restart TX CRC calculation */

	/* Send data bytes */
	outportb(DATA,*buf++);
	n--;
	write_scc(CTL,R0,RES_EOM_L);	/* Clear end-of-message flag */
	while(n-- != 0){
		while(!(read_scc(CTL,R0) & Tx_BUF_EMP))
			;
		outportb(DATA,*buf++);
	}
	/* Wait for tx buffer empty to drop to indicate CRC going out */
	while(read_scc(CTL,R0) & Tx_BUF_EMP)
		;
	/* Now wait for the transmitter to become ready again,
	 * once CRC finishes
	 */
	while(!(read_scc(CTL,R0) & Tx_BUF_EMP))
		;
}
/* Turn on transmitter and wait for keyup delay. This is done by
 * starting a garbage frame, sending enough characters to allow
 * for the delay, and then aborting it.
 */
void
txon()
{
	register int i;

	/* Turn on transmitter */
	write_scc(CTL,R5,DTR|Tx8|TxENAB|TxCRC_ENAB|RTS);

	/* Send dummy frame */
	for(i=KEYUP;i != 0; i--){
		while(!(read_scc(CTL,R0) & Tx_BUF_EMP))
			;
		outportb(DATA,'\0');
	}
	/* Now abort it */
	write_scc(CTL,R0,SEND_ABORT);
}
/* Turn off transmitter. First start a new dummy frame to allow the last
 * data frame to get out, then abort it.
 */
void
txoff()
{
	register int i;

	/* Wait in case a CRC is just going out */
	while(!(read_scc(CTL,R0) & Tx_BUF_EMP))
			;
	write_scc(CTL,R0,RES_Tx_CRC);	/* Restart TX CRC calculation */
	write_scc(CTL,R0,RES_EOM_L);	/* Clear end-of-message flag */
	/* Send dummy frame */
	for(i=TAIL;i != 0; i--){
		while(!(read_scc(CTL,R0) & Tx_BUF_EMP))
			;
		outportb(DATA,'\0');
	}
	write_scc(CTL,R0,SEND_ABORT);			/* Abort frame */
	write_scc(CTL,R5,DTR|Tx8|TxENAB|TxCRC_ENAB);	/* Drop carrier */
}

