#include "global.h"

#define	NSW	10	/* Number of stopwatch "memories" */

struct stopwatch {
	long calls;
	int16 maxval;
	int16 minval;
};
struct screen {
	char *save;		/* Screen save buffer */
	int row;		/* Saved cursor location */
	int col;
};
#define	NULLSCREEN	(struct screen *)0

extern struct stopwatch Sw[];
extern int16 Intstk[];	/* Interrupt stack defined in pcgen.asm */

/* In 8250.c: */
void asytimer __ARGS((void));

/* In scc.c: */
void scctimer __ARGS((void));
void sccstop __ARGS((void));

/* In pc.c: */
void clrbit __ARGS((unsigned port,char bits));
void ctick __ARGS((void));
INTERRUPT  __ARGS((*getirq __ARGS((unsigned int)) )) __ARGS((void));
void freescreen __ARGS((struct session *sp));
int getmask __ARGS((unsigned irq));
void ioinit __ARGS((void));
void iostop __ARGS((void));
int kbread __ARGS((void));
int maskoff __ARGS((unsigned irq));
int maskon __ARGS((unsigned irq));
void newscreen __ARGS((struct session *sp));
void setbit __ARGS((unsigned port,char bits));
int setirq __ARGS((unsigned irq,INTERRUPT (*handler) __ARGS((void))));
void sysreset __ARGS((void));
void systick __ARGS((void));
void rflush __ARGS((void));

/* In pcgen.asm: */
INTERRUPT btick __ARGS((void));
void chktasker __ARGS((void));
void chtimer __ARGS((INTERRUPT (*)()));
int16 getss __ARGS((void));
void giveup __ARGS((void));
int kbraw __ARGS((void));
INTERRUPT nullvec __ARGS((void));
void uchtimer __ARGS((void));

/* In stopwatch.asm: */
void swstart __ARGS((void));
int16 stopval __ARGS((void));

/* In sw.c: */
void swstop __ARGS((int n));

