#ifndef	NHS

#include "global.h"

/* Hardware-dependent routines for the DRSI or Eagle cards for the PC
 * driving a high speed modem. These cards both contain Zilog 8530s.
 */
#define	NHS	1		/* One card max */

struct hs {
	struct {
		INTERRUPT (*vec) __ARGS((void));
	} save;

	int16 addr;	/* Base I/O adHsess */
	int16 vec;	/* Vector */
	long ints;	/* Interrupt count */
};
extern struct hs Hs[];

/* Register offset info, specific to the DRSI PCPA and Eagle cards
 * E.g., to read the data port on channel A, use
 *      inportb(hdlc[dev].base + CHANA + DATA)
 */
#define	CHANB		0	/* Base of channel B regs */
#define	CHANA		2	/* Base of channel A regs */

/* 8530 ports on each channel */
#define	CTL	0
#define	DATA	1

struct hdlc {
	long rxints;		/* Receiver interrupts */
	long txints;		/* Transmitter interrupts */
	long exints;		/* External/status interrupts */
	long spints;		/* Special receiver interrupts */
	long rxbytes;		/* Total receive bytes */
	long nomem;		/* Buffer allocate failures */
	long toobig;		/* Giant receiver packets */
	long crcerr;		/* CRC Errors */
	long aborts;		/* Receiver aborts */
	long good;		/* Valid frames */
	long txpkts;
	long overrun;		/* Receiver overruns */

	int16 bufsiz;		/* Size of rcvbuf */

	int dev;		/* Device number */
	int16 ctl;		/* Control register */
	int16 data;		/* Data register */
	int16 speed;		/* Line speed, bps */
	long txdelay;		/* Keyup delay, ticks */ 
	char p;			/* P-persistence value */
	struct mbuf *txq;	/* Transmit queue */

	struct iface *iface;	/* Associated interface */
};

#define	OFF	0
#define	ON	1

/* Baud rate generator definitions */
struct baudrate {
	int16 speed;
	char val;
};
/* In hs.c: */
void hsint __ARGS((int dev));

/* In hsvec.asm: */
INTERRUPT hs0vec __ARGS((int dev));

#endif /* NHS */


