/* Defines for the ax.25 mailbox facility */
#ifndef	NUMMBX
#define NUMMBX		10		/* max number of mailbox sessions */
#include "timer.h"

#define MBXLINE		128		/* max length of line */
struct mbx {
	int state ;				/* mailbox state */
#define MBX_LOGIN	0		/* trying to log in */
#define MBX_CMD		1		/* in command mode */
#define MBX_SUBJ	2		/* waiting for a subject line */
#define MBX_DATA	3		/* collecting the message */
	char name[20] ;			/* Name of remote station */
	char *to ;			/* To-address in form user or user@host */
	char *origto ;			/* Original To-address, if rewritten */
	char *tofrom ;			/* Optional <from in to-address */
	char *tomsgid ;			/* Optional $msgid in to-address */
	FILE *tfile ;			/* Temporary file for message */
	char line[MBXLINE+1] ;	/* Room for null at end */
	int mbnum ;		/* which mailbox session is this? */
	int sid ;		/* Characteristics indicated by the SID */
				/* banner of the attaching station.  If */
				/* no SID was sent, this is zero.  If an */
				/* SID of any kind was received, it is */
				/* assumed that the station supports */
				/* abbreviated mail forwarding mode. */
#define	MBX_SID		0x01	/* Got any SID */
#define	MBX_SID_RLI	0x02	/* This is an RLI BBS, disconnect after F> */
				/* Space here for others, currently not of */
				/* interest to us. */
	char stype ;		/* BBS send command type (B,P,T, etc.) */
	int type ;		/* Type of session when invoking "chat" */
	int user;		/* User linkage area */
	char escape;		/* Escape character */
	int privs;		/* Privileges */
	char *path;		/* Directory path */
	char *startmsg;		/* Message to be sent at connect through any
				/* of the gateways */
	int current;		/* the current message number */
	int nmsgs;		/* number of messages in this mail box */
	int newmsgs;		/* number of new messages in mail box */
	int change;		/* mail file changed */
	int anyread;		/* true if any message has been read */
	FILE *mfile;		/* mail data file pointer */
	char area[20];		/* name of current mail area */
	long mboxsize;		/* size of mailbox when opened */
	long mysize;		/* size of my private mailbox */
	struct let *mbox;
} ;
#define 	NULLMBX		(struct mbx *)0

/* privilege codes in the userfile that are not needed by ftp */
#define AX25_CMD	8
#define TELNET_CMD	16
#define NETROM_CMD	32
#define SYSOP_CMD	64

/* Structure used for automatic flushing of gateway sockets */
struct gwalarm {
	int s1;
	int s2;
	struct timer t;
};

extern struct mbx *mbox[NUMMBX] ;
extern int ax25mbox ;
extern char Noperm[];

/* In ax_mbx.c: */
void mbx_incom __ARGS((int s,void *t,void *p));
void domboxdisplay __ARGS((void));

#endif	/* NUMMBX */

