/* OS- and machine-dependent stuff for IBM-PC running MS-DOS and Turbo-C */
#include <stdio.h>
#include <conio.h>
#include <dir.h>
#include <dos.h>
#include <io.h>
#include <sys/stat.h>
#include <string.h>
#include <process.h>
#include <fcntl.h>
#include <alloc.h>
#include <stdarg.h>
#include "global.h"
#include "config.h"
#include "mbuf.h"
#include "socket.h"
#include "internet.h"
#include "iface.h"
#include "cmdparse.h"
#include "pc.h"
#include "proc.h"
#include "session.h"

#define	CTLC	0x3
#define	DEL	0x7f

static int kbchar __ARGS((void));
static void kbint __ARGS((void));
extern int Curdisp;
extern struct proc *Display;
FILE *Rawterm;
unsigned _stklen = 8192;
int Tick;

/* This flag is set by setirq() if IRQ 8-15 is used, indicating
 * that the machine is a PC/AT with a second 8259 interrupt controller.
 * If this flag is set, the interrupt return code in pcgen.asm will
 * send an End of Interrupt command to the second 8259 as well as the
 * first.
 */
char Isat;

static char Ttbuf[BUFSIZ];
static char Tsbuf[BUFSIZ];
static int saved_break;

/* Keyboard input buffer */
#define	KBSIZE	256
static struct {
	char buf[KBSIZE];
	char *wp;
	char *rp;
	int cnt;
} Keyboard;

int
errhandler(errval,ax,bp,si)
int errval,ax,bp,si;
{
	return 3;	/* Fail the system call */
}

/* Called at startup time to set up console I/O, memory heap */
void
ioinit()
{
	/* Fail all I/O errors */
	harderr(errhandler);

	/* Save these two file table entries for something more useful */
	fclose(stdaux);
	fclose(stdprn);
	setbuf(stdout,Tsbuf);

	Rawterm = fopen("con","wb");
	setbuf(Rawterm,Ttbuf);
	/* this breaks tab expansion so you must use ANSI or NANSI */
	ioctl(fileno(Rawterm), 1, ioctl(fileno(Rawterm),0) & 0xff | 0x20);
	saved_break = getcbrk();
	setcbrk(0);

	/* Link timer handler into timer interrupt chain */
	chtimer(btick);

	/* Find out what multitasker we're running under, if any */
	chktasker();

	/* Initialize keyboard queue */
	Keyboard.rp = Keyboard.wp = Keyboard.buf;

}
/* Called just before exiting to restore console state */
void
iostop()
{
	struct iface *ifp,*iftmp;

	setbuf(Rawterm,NULLCHAR);
	ioctl(fileno(Rawterm), 1, ioctl(fileno(Rawterm), 0) & 0xff & ~0x20);
	setcbrk(saved_break);

	for(ifp = Ifaces;ifp != NULLIF;ifp = iftmp){
		iftmp = ifp->next;
		if_detach(ifp);
	}
#ifdef SCC
	sccstop();	/* reset int mask for all scc boards */
#endif
	/* Unlink timer handler from timer chain */
	uchtimer();
}
/* Spawn subshell */
int
doshell(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	char *command;
	int ret;

	if((command = getenv("COMSPEC")) == NULLCHAR)
		command = "/COMMAND.COM";
	ret = spawnv(P_WAIT,command,argv);

	return ret;
}

/* Keyboard interrupt handler */
static void
kbint()
{
	int sig = 0;
	int c;

	while((c = kbraw()) != -1 && Keyboard.cnt < KBSIZE){
		sig = 1;
		*Keyboard.wp++ = c;
		if(Keyboard.wp == &Keyboard.buf[KBSIZE])
			Keyboard.wp = Keyboard.buf;
		Keyboard.cnt++;
	}
	if(sig){
		psignal(&Keyboard,0);
	}
}
static int
kbchar()
{
	char i_state;
	char c;

	i_state = dirps();
	while(Keyboard.cnt == 0)
		pwait(&Keyboard);
	Keyboard.cnt--;
	restore(i_state);
	c = *Keyboard.rp++;
	if(Keyboard.rp == &Keyboard.buf[KBSIZE])
		Keyboard.rp = Keyboard.buf;
	return c;
}
/* Flush the raw terminal output */
void
rflush()
{
	fflush(Rawterm);
}

/* Read characters from the keyboard, translating them to "real" ASCII.
 * If none are ready, block. The F-10 key is special; translate it to -2.
 */
int
kbread()
{
	int c;

	if((c = kbchar()) == 0){
		/* Lead-in to a special char */
		c = kbchar();
		switch(c){
		case 3:		/* NULL (bizzare!) */
			c = 0;
			break;
		case 68:	/* F-10 key (used as command-mode escape) */
			c = -2;
			break;
		case 83:	/* DEL key */
			c = 0x7f;
			break;
		default:	/* Dunno what it is */
			c = -1;
		}
	}
	return c;
}

/* Called from the timer routine on each tick */
void
systick()
{
	/* Tickle the keyboard interrupt. This nonsense is
	 * necessary because there's no way to get a hardware interrupt
	 * from the BIOS.
	 */
	kbint();

#ifdef	ASY
	asytimer();
#endif
#ifdef SCC
	scctimer();
#endif

}
/* Install hardware interrupt handler.
 * Takes IRQ numbers from 0-7 (0-15 on AT) and maps to actual 8086/286 vectors
 * Note that bus line IRQ2 maps to IRQ9 on the AT
 */
int
setirq(irq,handler)
unsigned irq;
INTERRUPT (*handler)();
{
	/* Set interrupt vector */
	if(irq < 8){
		setvect(8+irq,handler);
	} else if(irq < 16){
		Isat = 1;
		setvect(0x70 + irq - 8,handler);
	} else {
		return -1;
	}
	return 0;
}
/* Return pointer to hardware interrupt handler.
 * Takes IRQ numbers from 0-7 (0-15 on AT) and maps to actual 8086/286 vectors
 */
INTERRUPT
(*getirq(irq))()
unsigned int irq;
{
	/* Set interrupt vector */
	if(irq < 8){
		return getvect(8+irq);
	} else if(irq < 16){
		return getvect(0x70 + irq - 8);
	} else {
		return NULLVIFP;
	}
}
/* Disable hardware interrupt */
int
maskoff(irq)
unsigned irq;
{
	if(irq < 8){
		setbit(0x21,(char)(1<<irq));
	} else if(irq < 16){
		irq -= 8;
		setbit(0xa1,(char)(1<<irq));
	} else {
		return -1;
	}
	return 0;
}
/* Enable hardware interrupt */
int
maskon(irq)
unsigned irq;
 {
	if(irq < 8){
		clrbit(0x21,(char)(1<<irq));
	} else if(irq < 16){
		irq -= 8;
		clrbit(0xa1,(char)(1<<irq));
	} else {
		return -1;
	}
	return 0;
}
/* Return 1 if specified interrupt is enabled, 0 if not, -1 if invalid */
int
getmask(irq)
unsigned irq;
{
	if(irq < 8)
		return (inportb(0x21) & (1 << irq)) ? 0 : 1;
	else if(irq < 16){
		irq -= 8;
		return (inportb(0xa1) & (1 << irq)) ? 0 : 1;
	} else
		return -1;
}
/* Called from assembler stub linked to BIOS interrupt 1C, called on each
 * hardware clock tick. Signal a clock tick to the timer process.
 */
void
ctick()
{
	Tick++;
	psignal(&Tick,1);
}
/* Set bit(s) in I/O port */
void
setbit(port,bits)
unsigned port;
char bits;
{
	outportb(port,(char)inportb(port)|bits);
}
/* Clear bit(s) in I/O port */
void
clrbit(port,bits)
unsigned port;
char bits;
{
	outportb(port,(char)(inportb(port) & ~bits));
}
/* Convert a pointer to a long integer */
long
ptol(p)
void *p;
{
	long x;

	x = FP_OFF(p);
#ifdef	LARGEDATA
	x |= (long)FP_SEG(p) << 16;
#endif
	return x;
}
void *
ltop(l)
long l;
{
	register unsigned seg,offset;

	seg = l >> 16;
	offset = l;
	return MK_FP(seg,offset);
}
void
sysreset()
{
	void (*foo) __ARGS((void));

	foo = MK_FP(0xffff,0);	/* FFFF:0000 is hardware reset vector */
	(*foo)();
}
void
newscreen(sp)
struct session *sp;
{
	if(sp != NULLSESSION)
		sp->screen = callocw(1,sizeof(struct screen));
}
void
freescreen(sp)
struct session *sp;
{
	if(sp == NULLSESSION || sp->screen == NULLSCREEN)
		return;
	if(sp->screen->save != NULLCHAR)
		free(sp->screen->save);
	free((char *)sp->screen);
}

/* Save specified session screen and resume console screen */
void
swapscreen(old,new)
struct session *old,*new;
{
	struct text_info tr;

	if(old == new)
		return;	/* Nothing to do */

	fflush(Rawterm);
	gettextinfo(&tr);
	if(old != NULLSESSION){
		/* Save old screen */
		if(old->screen->save == NULLCHAR)
			old->screen->save
			 = malloc(2*tr.screenheight*tr.screenwidth);
		if(old->screen->save != NULLCHAR)
			gettext(tr.winleft,tr.wintop,tr.winright,
			 tr.winbottom,old->screen->save);
		old->screen->row = tr.cury;
		old->screen->col = tr.curx;
	}
	if(new != NULLSESSION){
		/* Load new screen */
		if(new->screen->save != NULLCHAR){
			puttext(tr.winleft,tr.wintop,tr.winright,
			 tr.winbottom,new->screen->save);
			gotoxy(new->screen->col,new->screen->row);
			/* Free the memory (saves 4K on a continuous basis) */
			free(new->screen->save);
			new->screen->save = NULLCHAR;
		} else
			clrscr();	/* Start with a fresh slate */
	}
	alert(Display,1);	/* Wake him up */
}
void
display(i,v1,v2)
int i;
void *v1;
void *v2;
{
	int c;
	struct session *sp;

	/* This is very tricky code. Because the value of "Current" can
	 * change any time we do a pwait, we have to be careful to detect
	 * any change and go back and start again.
	 */
	for(;;){
		sp = Current;

		if(sp->morewait){
			pwait(&sp->row);
			if(sp != Current || sp->row <= 0){
				/* Current changed value, or the user
				 * hasn't really hit a key
				 */
				continue;
			}
			/* Erase the prompt */
			fprintf(Rawterm,"\r        \r");
		}
		sp->morewait = 0;
		if((c = rrecvchar(sp->output)) == -1){
			/* the alert() in swapscreen will cause this to
			 * return -1 when current changes
			 */
			pwait(NULL);	/* Prevent a nasty loop */
			continue;
		}
		putc(c,Rawterm);
		if(sp->record != NULLFILE)
			putc(c,sp->record);
		if(sp->flowmode && c == '\n' && --sp->row <= 0){
			fprintf(Rawterm,"--More--");
			sp->morewait = 1;
		}
	}
}
