#ifndef	NULLSESSION
#include <stdio.h>
#include "global.h"
#include "ftpcli.h"
#include "telnet.h"
#include "icmp.h"
#include "ax25.h"
#include "proc.h"
#include "tty.h"

#define	MOREROWS	24	/* rows on screen before --more-- */

/* Session control structure; only one entry is used at a time */
struct session {
	int type;
#define	FREE	0
#define	TELNET	1
#define	FTP	2
#define	AX25TNC	3
#define	FINGER	4
#define	PING	5
#define NRSESSION 6
#define	COMMAND	7
#define	MORE	8
#define	HOP	9
#define	TIP	10
	char *name;	/* Name of remote host */
	union {
		struct ftpcli *ftp;
		struct telnet *telnet;
	} cb;
	struct proc *proc;	/* Primary session process (e.g., tn recv) */
	struct proc *proc1;	/* Secondary session process (e.g., tn xmit) */
	struct proc *proc2;	/* Tertiary session process (e.g., upload) */
	int s;			/* Primary network socket (control for FTP) */
	FILE *record;		/* Receive record file */
	char *rfile;		/* Record file name */
	FILE *upload;		/* Send file */
	char *ufile;		/* Upload file name */
	struct ttystate ttystate;
	struct screen *screen;
	int input;		/* Input socket */
	int output;		/* Output socket */
	int flowmode;		/* control "more" mode */
	int row;		/* Rows remaining until "more" */
	int morewait;		/* Output driver is waiting on us */
};
#define	NULLSESSION	(struct session *)0

extern char *Sestypes[];
extern unsigned Nsessions;		/* Maximum number of sessions */
extern struct session *Sessions;	/* Session descriptors themselves */
extern struct session *Current;		/* Always points to current session */
extern struct session *Lastcurr;	/* Last non-command session */
extern struct session *Command;		/* Pointer to command session */

/* In session.c: */
void freesession __ARGS((struct session *sp));
struct session *sessptr __ARGS((char *cp));
struct session *newsession __ARGS((char *name,int type));
void upload __ARGS((int unused,void *sp1,void *p));

/* In pc.c: */
void swapscreen __ARGS((struct session *old,struct session *new));

extern int16 Lport;
#define	ALERT_EOF	1


#endif	/* NULLSESSION */
