#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"
#include "8250.h"
#include "asy.h"
#include "session.h"
#include "proc.h"
#include "tty.h"
#include "socket.h"
#include "commands.h"

static void tip_out __ARGS((int dev,void *n1,void *n2));
static int dumpit __ARGS((struct iface *ifp,struct mbuf *bp));


/* Execute user telnet command */
int
dotip(argc,argv,p)
int argc;
char *argv[];
void *p;
{
	struct session *sp;
	register struct iface *ifp;
	register struct asy *ap;
	int (*rawsave) __ARGS((struct iface *,struct mbuf *));
	int dev;
	int c;
	
	if((ifp = if_lookup(argv[1])) == NULLIF){
		tprintf("Interface %s unknown\n",argv[1]);
		freeargs(argc,argv);
		return 1;
	}
	for(dev=0,ap = Asy;dev < Nasy;dev++,ap++)
		if(ap->iface == ifp)
			break;
	if(dev == Nasy){
		tprintf("Interface %s not asy port\n",argv[1]);
		freeargs(argc,argv);
		return 1;
	}
	if(ifp->raw == dumpit){
		tprintf("Tip session already active on %s\n",argv[1]);
		freeargs(argc,argv);
		return 1;
	}
	/* Allocate a session descriptor */
	if((sp = newsession(argv[1],TIP)) == NULLSESSION){
		tprintf("Too many sessions\n");
		freeargs(argc,argv);
		return 1;
	}
	/* Save output handler and temporarily redirect output to null */
	rawsave = ifp->raw;
	ifp->raw = dumpit;

	/* Suspend packet input drivers */
	suspend(ifp->proc);

	freeargs(argc,argv);

	/* Put tty into raw mode */
	sp->ttystate.echo = 0;
	sp->ttystate.edit = 0;
	sockmode(sp->output,SOCK_BINARY);

	/* Now fork into two paths, one rx, one tx */
	sp->proc1 = newproc("tip_out",256,tip_out,dev,NULL,NULL);
	while((c = get_asy(ifp->dev)) != -1)
		tputc(c & 0x7f);

	killproc(sp->proc1);
	sp->proc1 = NULLPROC;
	ifp->raw = rawsave;
	resume(ifp->proc);
	keywait(NULLCHAR,1);
	freesession(sp);
	return 1;
}
static void
tip_out(dev,n1,n2)
int dev;
void *n1,*n2;
{
	struct mbuf *bp;
	int c;

	while((c = recvchar(Curproc->input)) != EOF){
		bp = pushdown(NULLBUF,1);
		*bp->data = c;
		bp->cnt = 1;
		asy_send(dev,bp);
	}
}
static int
dumpit(ifp,bp)
struct iface *ifp;
struct mbuf *bp;
{
	free_p(bp);
	return 0;
}

