#ifndef	NULLUSOCK

struct loc {
	struct mbuf *q;
	int hiwat;		/* Flow control point */
	int flags;
#define	LOC_SHUTDOWN	1
};
#define	NULLLOC	(struct loc *)0
#define	LOCDFLOW	5	/* dgram socket flow-control point, packets */
#define	LOCSFLOW	2048	/* stream socket flow control point, bytes */
#define	SOBUF		256	/* Size of buffer for usputc()/usprintf() */
#define	SOCKBASE	128	/* Start of socket indexes */

union cb {
	struct tcb *tcb;
	struct ax25_cb *ax25;
	struct udp_cb *udp;
	struct raw_ip *rip;
	struct raw_nr *rnr;
	struct nr4cb *nr4;
	struct loc *local;
	char *p;
};
union sp {
	struct sockaddr *sa;
	struct sockaddr_in *in;
	struct sockaddr_ax *ax;
	struct sockaddr_nr *nr;
	char *p;
};

/* User sockets */
struct usock {
	struct proc *owner;
	int refcnt;
	char noblock;
	char type;
#define	NOTUSED			0
#define	TYPE_TCP		1
#define	TYPE_UDP		2
#define	TYPE_AX25I		3
#define	TYPE_AX25UI		4
#define TYPE_RAW		5
#define TYPE_NETROML3		6
#define TYPE_NETROML4		7
#define	TYPE_LOCAL_STREAM	8
#define	TYPE_LOCAL_DGRAM	9
	int rdysock;
	union cb cb;
	char *name;
	int namelen;
	char *peername;
	int peernamelen;
	char errcodes[4];	/* Protocol-specific error codes */
	struct mbuf *obuf;	/* Output buffer */
	struct mbuf *ibuf;	/* Input buffer */
	char eol[3];		/* Text mode end-of-line sequence, if any */
	int flag;		/* Mode flags, defined in socket.h */
	int flush;		/* Character to trigger flush, if any */
};
#define	NULLUSOCK	((struct usock *)0)

extern char Badsocket[];
extern char *Socktypes[];
extern struct usock *Usock;
extern int Nusock;

struct usock *itop __ARGS((int s));
void st_garbage __ARGS((int red));

#endif /* NULLUSOCK */
