/*
 *  linux/ibcs/bsdsocket.c
 *
 *  Copyright (C) 1994  Mike Jagdis
 *
 * $Id: bsdsocket.c,v 1.1 1994/06/23 15:54:52 mike Exp $
 * $Source: /var/CVS/ibcs/bsdsocket.c,v $
 */
#ifdef EMU_BSD

#include <linux/mm.h>
#include <linux/net.h>
#include <linux/ptrace.h>
#include <linux/socket.h>
#include <linux/sys.h>
#include <asm/segment.h>

#include <ibcs/ibcs.h>
#include <ibcs/bsd.h>


int
bsd_connect(struct pt_regs *regs)
{
	int error;
	char *addr;
	unsigned short s;

	/* With BSD the first byte of the sockaddr struct is a length and
	 * the second is the address family. With Linux the address family
	 * occupies both bytes.
	 */
	addr = (char *)get_fs_long(((unsigned long *)regs->esp) + 2);
	if ((error = verify_area(VERIFY_READ, addr, 2)))
		return error;
	s = get_fs_word(addr);
	put_fs_word(s>>8, addr);

	error = SYS(socketcall)(SYS_CONNECT, ((unsigned long *)regs->esp) + 1);

	put_fs_word(s, addr);
	return error;
}

#endif /* EMU_BSD */
