#include <ibcs/signal.h>


static unsigned long linux_to_ibcs_signals[NSIGNALS] = {
	0,
	IBCS_SIGHUP,	IBCS_SIGINT,	IBCS_SIGQUIT,	IBCS_SIGILL,
	IBCS_SIGTRAP,	IBCS_SIGABRT,	-1,		IBCS_SIGFPE,
	IBCS_SIGKILL,	IBCS_SIGUSR1,	IBCS_SIGSEGV,	IBCS_SIGUSR2,
	IBCS_SIGPIPE,	IBCS_SIGALRM,	IBCS_SIGTERM,	IBCS_SIGSEGV,
	IBCS_SIGCHLD,	IBCS_SIGCONT,	IBCS_SIGSTOP,	IBCS_SIGTSTP,
	IBCS_SIGTTIN,	IBCS_SIGTTOU,	IBCS_SIGIO,	IBCS_SIGGXCPU,
	IBCS_SIGGXFSZ,	IBCS_SIGVTALRM,	IBCS_SIGPROF,	IBCS_SIGWINCH,
	-1,		IBCS_SIGPWR,	-1
};

static unsigned long ibcs_to_linux_signals[NSIGNALS] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGIOT,		SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGUSR1,
	SIGUSR2,	SIGCHLD,	SIGPWR,		SIGWINCH,
	-1,		SIGPOLL,	SIGSTOP,	SIGTSTP,
	SIGCONT,	SIGTTIN,	SIGTTOU,	SIGVTALRM,
	SIGPROF,	SIGXCPU,	SIGXFSZ
};


#ifdef EMU_BSD
static unsigned long linux_to_bsd_signals[NSIGNALS] = {
	0,
	BSD_SIGHUP,	BSD_SIGINT,	BSD_SIGQUIT,	BSD_SIGILL,
	BSD_SIGTRAP,	BSD_SIGABRT,	BSD_SIGEMT,	BSD_SIGFPE,
	BSD_SIGKILL,	BSD_SIGUSR1,	BSD_SIGSEGV,	BSD_SIGUSR2,
	BSD_SIGPIPE,	BSD_SIGALRM,	BSD_SIGTERM,	BSD_SIGSEGV,
	BSD_SIGCHLD,	BSD_SIGCONT,	BSD_SIGSTOP,	BSD_SIGTSTP,
	BSD_SIGTTIN,	BSD_SIGTTOU,	BSD_SIGIO,	BSD_SIGXCPU,
	BSD_SIGXFSZ,	BSD_SIGVTALRM,	BSD_SIGPROF,	BSD_SIGWINCH,
	-1, BSD_SIGTERM, -1
};

static unsigned long bsd_to_linux_signals[NSIGNALS] = {
	0,
	SIGHUP,		SIGINT,		SIGQUIT,	SIGILL,
	SIGTRAP,	SIGABRT,	SIGUNUSED,	SIGFPE,
	SIGKILL,	SIGUNUSED,	SIGSEGV,	SIGUNUSED,
	SIGPIPE,	SIGALRM,	SIGTERM,	SIGURG,
	SIGSTOP,	SIGTSTP,	SIGCONT,	SIGCHLD,
	SIGTTIN,	SIGTTOU,	SIGIO,		SIGXCPU,
	SIGXFSZ,	SIGVTALRM,	SIGPROF,	SIGWINCH,
	29,		SIGUSR1,	SIGUSR2
};
#endif

#ifndef INIT_MM
unsigned long *signal_map_to_linux[] = {
	NULL,
	ibcs_to_linux_signals,
	ibcs_to_linux_signals,	/* SVR3 is a subset of SVR4 */
	ibcs_to_linux_signals,
	ibcs_to_linux_signals,
	ibcs_to_linux_signals,
#ifdef EMU_BSD
	bsd_to_linux_signals	/* BSD-ish - probably wrong so far. */
#else
	NULL
#endif /* EMU_BSD */
};

unsigned long *signal_map_from_linux[] = {
	NULL,
	linux_to_ibcs_signals,
	linux_to_ibcs_signals,	/* SVR3 is a subset of SVR4 */
	linux_to_ibcs_signals,
	linux_to_ibcs_signals,
	linux_to_ibcs_signals,
#ifdef EMU_BSD
	linux_to_bsd_signals	/* BSD-ish - probably wrong so far. */
#else
	NULL
#endif /* EMU_BSD */
};
#endif /* !INIT_MM */
