/*
 *  linux/ibcs/wysev386i.c
 *
 *  Copyright (C) 1994  Mike Jagdis (jaggy@purplet.demon.co.uk)
 *
 * $Id: wysev386i.c,v 1.3 1994/06/23 15:54:56 mike Exp $
 * $Source: /var/CVS/ibcs/wysev386i.c,v $
 */

/* This file is misnamed. It should really be called something like
 * bsdioctl.c as this is for the BSD networking stack that Wyse bolted
 * on to their SVR3.
 */

#include <linux/types.h>
#include <linux/errno.h>
#include <linux/sockios.h>
#include <linux/kernel.h>

#include <ibcs/ibcs.h>
#include <ibcs/bsd.h>
#include <ibcs/wysev386i.h>

#ifdef IBCS_TRACE
#include <ibcs/trace.h>
#endif

int
wv386_ioctl(int fd, unsigned int ioctl_num, void *arg)
{
	switch (ioctl_num) {
		case WVR3_SIOCSHIWAT:		/* set high watermark */
		case WVR3_SIOCGHIWAT:		/* get high watermark */
		case WVR3_SIOCSLOWAT:		/* set low watermark */
		case WVR3_SIOCGLOWAT:		/* get low watermark */
			/* Maybe we should just lie? */
			return -EPERM;

		case WVR3_SIOCATMARK:		/* at oob mark? */
			return SYS(ioctl)(fd, SIOCATMARK, arg);
		case WVR3_SIOCSPGRP:		/* set process group */
			return SYS(ioctl)(fd, SIOCSPGRP, arg);
		case WVR3_SIOCGPGRP:		/* get process group */
			return SYS(ioctl)(fd, SIOCGPGRP, arg);

		case WVR3_SIOCADDRT:		/* add route */
			return SYS(ioctl)(fd, SIOCADDRT, arg);
		case WVR3_SIOCDELRT:		/* delete route */
			return SYS(ioctl)(fd, SIOCDELRT, arg);

		case WVR3_SIOCSIFADDR:		/* set ifnet address */
			return SYS(ioctl)(fd, SIOCSIFADDR, arg);
		case WVR3_SIOCGIFADDR:		/* get ifnet address */
			return SYS(ioctl)(fd, SIOCGIFADDR, arg);
		case WVR3_SIOCSIFDSTADDR:	/* set p-p address */
			return SYS(ioctl)(fd, SIOCSIFDSTADDR, arg);
		case WVR3_SIOCGIFDSTADDR:	/* get p-p address */
			return SYS(ioctl)(fd, SIOCGIFDSTADDR, arg);
		case WVR3_SIOCSIFFLAGS:		/* set ifnet flags */
			return SYS(ioctl)(fd, SIOCSIFFLAGS, arg);
		case WVR3_SIOCGIFFLAGS:		/* get ifnet flags */
			return SYS(ioctl)(fd, SIOCGIFFLAGS, arg);
		case WVR3_SIOCGIFBRDADDR:	/* get broadcast addr */
			return SYS(ioctl)(fd, SIOCGIFBRDADDR, arg);
		case WVR3_SIOCSIFBRDADDR:	/* set broadcast addr */
			return SYS(ioctl)(fd, SIOCSIFBRDADDR, arg);
		case WVR3_SIOCGIFCONF:		/* get ifnet list */
			return SYS(ioctl)(fd, SIOCGIFCONF, arg);
		case WVR3_SIOCGIFNETMASK:	/* get net addr mask */
			return SYS(ioctl)(fd, SIOCGIFNETMASK, arg);
		case WVR3_SIOCSIFNETMASK:	/* set net addr mask */
			return SYS(ioctl)(fd, SIOCSIFNETMASK, arg);
		case WVR3_SIOCGIFMETRIC:	/* get IF metric */
			return SYS(ioctl)(fd, SIOCGIFMETRIC, arg);
		case WVR3_SIOCSIFMETRIC:	/* set IF metric */
			return SYS(ioctl)(fd, SIOCSIFMETRIC, arg);
		case WVR3_SIOCSIFHADDR:		/* set hardware addr */
			return SYS(ioctl)(fd, SIOCSIFHWADDR, arg);
		case WVR3_SIOCGIFHADDR:		/* get hardware addr */
			return SYS(ioctl)(fd, SIOCGIFHWADDR, arg);
		case WVR3_SIOCRIFHADDR:		/* reset hardware addr */
			return 0; /* LIE??? */

		case WVR3_SIOCSARP:		/* set arp entry */
			return SYS(ioctl)(fd, SIOCSARP, arg);
		case WVR3_SIOCGARP:		/* get arp entry */
			return SYS(ioctl)(fd, SIOCGARP, arg);
		case WVR3_SIOCDARP:		/* delete arp entry */
			return SYS(ioctl)(fd, SIOCDARP, arg);

		case WVR3_SIOCADDMULTI:		/* set multicast addr */
		case WVR3_SIOCDELMULTI:		/* set multicast addr */
			printk(KERN_ERR "iBCS2: unimplemented Wyse Unix TCP/IP ioctl 0x%lx\n",
				(unsigned long)ioctl_num);
			return -EINVAL;
	}

	printk(KERN_ERR "iBCS2: unsupported Wyse Unix TCP/IP ioctl 0x%lx\n",
		(unsigned long)ioctl_num);
	return -EINVAL;
}
