#! /usr/bin/perl
#
# @(#) K_fix_perms.pl  1993-07-14  DBK
#
# (C) Copyright 1993 by D. Brian Kimmel.
# All rights reserved.
#
# See README, Artistic and Copying for further information
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the Licenses
# for more details.
#
###############################################################################

# Get options to report or fix
$FixIt = 0;
if ($ARGV[0] eq '-f') {
    shift;
    $FixIt = 1;
    print "Fixing up the works...\n";
}

# Grab Username and groupname info from /etc/passwd and /etc/group
while (($name, $passwd, $uid) = getpwent) {
    $uid{$name} = $uid;
}
while (($name, $passwd, $gid) = getgrent) {
    $gid{$name} = $gid;
}

# Process some/all databases
$Base = "/usr/src/Kimbro/Base/";
opendir(DD, $Base) ||
    die "Can't open directory $Base for database files. $!\n";
@DbFiles = sort grep(!/^\./, readdir(DD));
closedir(DD);

# Process the files we found
foreach $Name (@DbFiles) {
    next if $Name =~ "Test";
    next if $Name =~ "README";
    &Check_Dir("$Base$Name");
}

exit;
##############################################################################


sub Check_Dir {
    local ($DirName) = @_;

    open(FX, "< $DirName") ||
	die "fixup.pl: Can't open file \"$DirName\": $!\n";
    while (<FX>) {
	chop;
	next if /^\s*#/;
	next if /^\s*$/;
	if (&Get_Headers($_)) {
	    next;
	}
	($Inode, $Perm, $Links, $Own, $Grp, $Nm) =
	    /^\s*(-?\d+)\s+(.{10})\s+(\d+)\s+(\S+)\s+(\S+)\s+(.*)$/;
	($Name, $LName) = ($Nm =~ /(\S+)\s*\S*\s*(.*)/);
	$FullName = "$DirName$Name";
	$List{$Nme} = $Links;
	$PO = &extract_perms($Perm);

	next if &Stat($FullName);

# Detect the errors
	$ErrFlag = 0;
	$Err = "";

	if  ($s_mode != $PO) {
	    $ErrFlag += 1;
	    if (&abs($s_mode, $PO) < 10000) {
		$Err .= "    Permissions Are: " . ($s_mode%10000 )
		    . "  Should be: " . ($PO%10000) . "\n";
	    } else {
		$Err .= "    Permissions Are: $s_mode  Should be: $PO\n";
	    }
	}
	if  ($s_PW{$s_uid} ne $Own) {
	    $ErrFlag += 2;
	    $Err .= "    Ownership Is: $s_PW{$s_uid}  Should be: $Own\n";
	}
	if  ($GW{$s_gid} ne $Grp) {
	    $ErrFlag += 4;
	    $Err .= "    Group Is: $GW{$s_gid}  Should be: $Grp\n";
	}
	if ($Inode == 0) {
	    if ($s_ino != $Last_ino) {
		$ErrFlag += 8;
		$Err .= "    Not linked properly 'ln $LinkName $Name'\n";
	    }
	} else {
	    $LastInode = $Inode;
	    $Last_ino = $s_ino;
	    $LinkName = $Name;
	}
	if ($ErrFlag) {
	    $Kind = ($s_mode >= 100000) ? "File" : "Directory";
	    print "*** Error(s) in $Kind $FullName\n";
	    print "$Err\n";
	}
	if ($FixIt) {
	    if (($ErrFlag/1) % 2) {
		$x = oct($PO%10000);
##		print "chmod ($x, $FullName)\n";
		$y = chmod ($x, $FullName);
##		print "$y files chmod'd\n";
	    }
	    if (($ErrFlag/2) % 4) {
##		print "chown ($uid{$Own}, $gid{$Grp}, $FullName)\n";
		chown ($uid{$Own}, $gid{$Grp}, $FullName);
	    }
	}
    }
    close FX;
}
##############################################################################
# Extract a numeric (octal) set of perms from the ls perms string.
#
# 1222333444
# 1 = d, l, (c, b, f, p)
# 2 = rwx, rws, rwS
# 3 = rwx, rws, rwS
# 4 = rwx, rwt, rwT

sub extract_perms {
    local($Perms) = @_;
    local($P_O);

    $P_O = 0;
    ($p1, $p2, $p3, $p4) = ($Perms =~ /(.)(...)(...)(...)/);

    if ($p1 eq 'p') { $P_O +=  10000; } # Pipe
    if ($p1 eq 'c') { $P_O +=  20000; } # Character device
    if ($p1 eq 'd') { $P_O +=  40000; }	# Directory
    if ($p1 eq 'b') { $P_O +=  60000; } # Block device
    if ($p1 eq '-') { $P_O += 100000; }	# File
    if ($p1 eq 'l') { $P_O += 120000; }	# Sim-link
    if ($p1 eq 's') { $P_O += 140000; }	# Lock File

    if ($p2 =~ /r/) { $P_O +=    400; }
    if ($p2 =~ /w/) { $P_O +=    200; }
    if ($p2 =~ /x/) { $P_O +=    100; }
    if ($p2 =~ /s/) { $P_O +=   4100; }
    if ($p2 =~ /S/) { $P_O +=   4000; }

    if ($p3 =~ /r/) { $P_O +=     40; }
    if ($p3 =~ /w/) { $P_O +=     20; }
    if ($p3 =~ /x/) { $P_O +=     10; }
    if ($p3 =~ /s/) { $P_O +=   2010; }
    if ($p3 =~ /S/) { $P_O +=   2000; }

    if ($p4 =~ /r/) { $P_O +=      4; }
    if ($p4 =~ /w/) { $P_O +=      2; }
    if ($p4 =~ /x/) { $P_O +=      1; }
    if ($p4 =~ /t/) { $P_O +=   1001; }
    if ($p4 =~ /T/) { $P_O +=   1000; }

    return $P_O;
}
##############################################################################
# Stat the file to get current info

sub Stat {
    local($Name) = @_;
    local ($T);

    ($s_dev, $s_ino, $s_mode, $s_link, $s_uid, $s_gid, $s_rdev, $s_size,
     $s_atime, $s_mtime, $s_ctime, $s_blksize, $s_blocks) = lstat($Name);
    if ($s_ino == 0) {
	print "*** File $Name is missing\n";
	return 1;
    }
    $Disk{$Name} = $s_link;
    $s_mode = sprintf("%o", $s_mode);
    if (! defined($s_PW{$s_uid})) {
	$T = getpwuid($s_uid);
	$s_PW{$s_uid} = ($T ne "") ? $T : $s_uid;
    }
    if (! defined($GW{$s_gid})) {
	$T = getgrgid($s_gid);
	$GW{$s_gid} = ($T ne "") ? $T : $s_gid;
    }
    return 0;
}
##############################################################################

sub Get_Headers {
    local($_) = @_;

    if (/DirName\s*:\s(.*)$/) {
	$DirName = $1;
	return 1;
    }
    if (/User\s*:\s+(.*)/) {
	@Ulist = split(/,\s*/, $1);
	print " Users: ", @Ulist, "\n";
	foreach $User (@Ulist) {
	    if (! defined($uid{$User})) {
		print "Error: Required user \"$User\" is not in the password file\n";
	    }
	}
	return 1;
    }
    if (/Group\s*:\s+(.*)/) {
	@Glist = split(/,\s*/, $1);
	print " Groups: ", @Glist, "\n";
	foreach $Group (@Glist) {
	    if (! defined($gid{$Group})) {
		print "Error: Required group \"$Group\" is not in the group file\n";
	    }
	}
	return 1;
    }
    return 0;
}
##############################################################################

sub abs {
    local($a, $b) = @_;
    local($x);
    $x = $a - $b;
    $x = -$x if ($x < 0);
}
##############################################################################
##############################################################################
### END
