REM ------------------------------------------
REM 		Pason 1.0         for Psion 3a
REM 		1 Nov 1994     by Steve Hawtin
REM
REM A routine to turn the password on at a set
REM time every day.
REM The idea is that the first time the 
REM Psion is turned on for the day you must 
REM provide a password, the rest of the day
REM the password is disabled.
REM ------------------------------------------
REM  1994 Steve Hawtin
REM
REM This file may be freely distributed 
REM provided that the file pason.txt is 
REM included in the distribution
REM ------------------------------------------

REM A macro to turn on the password on a Psion 3A
REM this assumes that there is a file called 
REM "M:\pason.dat" with an address of an encrypted
REM password for the machine

REM the only way this will be of use to you is if
REM the macro is invoked by the "pason" program

PROC macro:
	GLOBAL passwd$(128),salt&,onp%

	getword:
	UseApp:("System")
	Key:(631) rem Psion-W
	REM Now type the password
	keystr:(passwd$)
	REM Now set the machine to use the password
	Enter:
	Tab:
	IF onp%
		Down:
	ELSE
		Up:
	ENDIF
	Enter:
	Enter:
ENDP

PROC keystr:(a$)
	LOCAL count%,a%,pas$(128)
	
	pas$ = encode$:(salt&,a$)
	count%=LEN(pas$)
	a% = ADDR(pas$)+1
	WHILE(count% > 0)
		REM 
		Key:(PEEKB(a%))
		a% = a%+1
		count% = count%-1
	ENDWH
ENDP

PROC getword:
	REM Open the file, read the password and 
	REM decode it
	REM Then remove the file
	LOCAL fh%,ret%,tmpdat$(64)
	
	tmpdat$ = "M:\PASON.DAT"
	ret% = IOOPEN(fh%,tmpdat$,$0)
	IF ret%<0
		STOP
	ENDIF
	IOREAD(fh%,ADDR(onp%),2)
	IOREAD(fh%,ADDR(salt&),4)
	IOREAD(fh%,ADDR(passwd$),20)
	IOCLOSE(fh%)
	REM The macro should remove the tmpdat$ file
	DELETE tmpdat$
ENDP

PROC encode$:(s&,a$)
	REM encode a password, use a simple algorithm
	LOCAL count%,adr%,ret$(64),m1%,m2%
	
	m1% = s& AND $ff
	m2% = (s& / $100) AND $ff
	ret$ = a$
	count% = LEN(ret$)
	adr% = ADDR(ret$)+1
	WHILE count%>0
		IF(count% AND 1)
			POKEB adr%,xor%:(PEEKB(adr%),m1%)
		ELSE
			POKEB adr%,xor%:(PEEKB(adr%),m2%)
		ENDIF
		count%=count%-1
		adr%=adr%+1
	ENDWH
	RETURN ret$
ENDP

PROC xor%:(x%,y%)
	RETURN((x% OR y%)AND(NOT(x% AND y%)))
ENDP
