/*
   Example AfterFile

   This is a program that sets up a Windows association between files with
   the extension .SVI and the install build program SVI_BLD2.EXE.

   It is intended as an example of the AfterFile function of SVInstal.

   Under the "Options" section of SVI_BLD2, you can specify a program to be
   run at the end of the installation. This is just one example of what
   might be done by the AfterFile.

   Rob Stevens
   Soft Ventures
   (403) 278-1681
   CIS 71441,734

   NOTE, this is just an example an is not intended to be a complete treatment
   of the subject of adding associations to Windows. You can edit the WIN.INI
   file to see the association. Feel free to modify this code to meet your
   requirements. If you prefer, Soft Ventures will write a custom AfterFile
   for you for a small fee.

*/

#include <windows.h>
#include <stdio.h>

main()
{
  BOOL lSuccess;
  char szWinEntry[] = "SVI_BLD2.EXE ^.svi";


  /* This program puts an entry in WIN.INI, ".svi SVI_BLD2.EXE ^.svi" under
     the [Extensions] section.
  */

  lSuccess = WriteProfileString("Extensions", "svi", szWinEntry);

  if (lSuccess)
      MessageBox(0, "Association added successfully",
              "Write WIN.INI", MB_OK);
  else
      MessageBox(0, "Association could not be added",
              "Write WIN.INI", MB_ICONSTOP);
}

