/*
 * awklib.h - defines, global variables, and function prototypes for
 * AWKLIB routines.
 *
 * Copyright 1988, Jim Mischel.  All rights reserved.
 *
 */
extern int RSTART;
extern int RLENGTH;
extern int NF;
extern char *FS;
extern char *FS_PAT;
extern char *FIELDS[];

#define MAXSTR	1024
#define MAXPAT	2*MAXSTR

void	pascal awk_init (void);
char *	pascal setfs 	(char *fs);
char * 	pascal match 	(char *s, char *re);
char * 	pascal re_match (char *s, char *pat);
char * 	pascal makepat 	(char *re, char *pat);
int 	pascal split 	(char *s, char **a, char *fs);
int	pascal re_split (char *s, char **a, char *pat);
int	pascal getline 	(char *s, int nchar, FILE *infile);
int	pascal sub 	(char *re, char *replace, char *str);
int	pascal re_sub 	(char *pat, char *replace, char *str);
int	pascal gsub 	(char *re, char *replace, char *str);
int	pascal re_gsub 	(char *pat, char *replace, char *str);
char * 	pascal strins 	(char *s, char *i, int pos);
char * 	pascal strcins 	(char *s, int ch, int pos);
char * 	pascal strdel 	(char *s, int pos, int n);
char * 	pascal strcdel 	(char *s, int pos);
char * 	pascal strccat 	(char *s, int c);
