/*
 * qstring.c - finds and outputs all quoted strings in a C source file.
 *
 * Copyright 1988, Jim Mischel
 */
#include <stdio.h>
#include <string.h>
#include "awklib.h"

void main (void) {
    char pat[MAXPAT];
    char buff[MAXSTR];
    char s[MAXSTR];
    char *c;

    awk_init ();
    if (makepat("\"[^\"]*\"", pat) == NULL) {
	fprintf (stderr, "Error compiling pattern string.\n");
	return;
    }

    while (gets (buff) != NULL) {
	c = buff;
	while ((c = re_match (c, pat)) != NULL) {
	    strncpy (s, c, RLENGTH);
	    s[RLENGTH] = '\0';
	    puts (s);
	    c += RLENGTH;
	}
    }
}
