/*
 * uidflt.c - Locate and output all lines starting with Fm: or To: and also
 * containing a CompuServe User-ID.
 *
 * Copyright 1988, Jim Mischel.  All rights reserved.
 */
#include <stdio.h>
#include <ctype.h>
#include "awklib.h"

#define	UID "^(Fm|To): [^ ]+.*7[0-7][0-7][0-7][0-7],[0-7]+"
void main (void) {
    char *a[128];
    char buff[MAXSTR];
    char pat[MAXPAT];
    int x;

    awk_init ();			/* initialize AWKLIB */

    for (x = 0; x < 128; x++)
	a[x] = NULL;
    /*
     * I compile the pattern here in order to speed up the processing.
     * re_match() is much faster than match() because it works with a
     * pre-compiled pattern whereas match() must compile the pattern and
     * then call re_match().
     *
     * In general, if you're going to be using the same pattern on many
     * input strings, compile the pattern with makepat() and then use
     * re_match() in the loop.  If you're going to be using different
     * patterns, use match() without compiling the pattern first.
     *
     * This holds true for sub() [re_sub()], gsub() [re_gsub()] and
     * split() [re_split()] as well.
     */
    if (makepat (UID, pat) == NULL) {
	fprintf (stderr, "Error compiling regular expression.\nProgram aborted\n");
	return;
    }

    /*
     * Notice that I use gets() here instead of getline().  getline() is much
     * slower because it must split() the fields.  In general, use getline()
     * only when you must have the fields split on all (or most) input records.
     */
    while (gets (buff) != NULL)
	if (re_match (buff, pat) != NULL) {
	    char *c;
	    buff[RSTART + RLENGTH] = '\0';
	    re_split (&buff[RSTART+4], a, FS_PAT);
            c = a[NF];
	    while (!isdigit (*c))
		c++;
	    printf ("%s", c);
	    for (x = 1; x < NF; x++)
		printf (" %s", a[x]);
	    printf ("\n");
	}
}
