/* quick sort almost anything using an algorithm from N. Wirth's book
 * 'Algorithms + Data Structures = Programs'
 * written by Ron Andrews 18-JUL-86 for IBM PC
 * this is a non-recursive version to improve speed
 * modified for Microsoft 'C' 28-FEB-87
 *
 * 'n' is the number of items to sort (2 - 32767 only)
 * 'i' and 'j' are ints
 *
 * 'load(i)' is a function which loads item 'i' into temporary storage
 *
 * 'check(i)' is a function which compares the stored item with item 'i'
 * return -1 if temporary < item 'i'
 * return 0 if temporary == item 'i'
 * return 1 if temporary > item 'i'
 *
 * 'swap(i,j)' is a function which swaps items 'i' and 'j'
 *
 * obviously the functions need intimate knowledge of the items being sorted
 */

rqsort(n,load,check,swap)
int n,(*load)(),(*check)(),(*swap)();
	{
	register i,j;
	static int l,r,s,stackl[20],stackr[20];
	if (n <= 1)
		return;
	s = 0;
	stackl[0] = 0;
	stackr[0] = n - 1;
	while (s >= 0)
		{
		l = stackl[s];
		r = stackr[s];
		--s;
		while (l < r)
			{
			i = l;
			j = r;
			(*load)((unsigned)(i + j) >> 1);
			while (i <= j)
				{
				while ((*check)(i) > 0)
					++i;
				while ((*check)(j) < 0)
					--j;
				if (i <= j)
					{
					if (i < j)
						(*swap)(i,j);
					++i;
					--j;
					}
				}
			if ((j - l) < (r - i))
				{
				if (i < r)
					{
					++s;
					stackl[s] = i;
					stackr[s] = r;
					}
				r = j;
				}
			else
				{
				if (l < j)
					{
					++s;
					stackl[s] = l;
					stackr[s] = j;
					}
				l = i;
				}
			}
		}
	}
