#include "qwik.h"

#ifdef TURBO
#include "dir.h"
#endif

char dir_list[DIR_MAX][13];        /* array for directory names */
unsigned char all_files[4]="*.*";  /* search mask for directory handler */
                                   /* if a mask other than this is desired,
                                      it must defined within your code. */  

/****************************************************************************
 * directory() opens a window and displays a directory listing.             *
 *                                                                          *
 * Paramters are:                                                           *
 *              mask        - pointer to filename mask to use.              *
 *                                                                          *
 *              dir_name    - pointer to string containing the path of the  *
 *                            directory to be listed.                       *
 *                                                                          *
 * The function provides for full window scrolling and file selection.      *
 * On return 2 fields in the structure "dir" (defined in global data) will  *
 * contain the last key pressed in dir.key and the index to the name        *
 * selected in dir.indx.  This index points into the array "dir_list[]"     *
 * The caller should check the value of dir.key to see if the index in      *
 * dir.indx is valid.                                                       *
 * In addition, the function returns a integer value of -1 if the directory *
 * path was not located or opened.  Deletion and file renaming are the only *
 * functions supported within this function.  A password is required  for   *
 * file deletion.                                                           *
 ***************************************************************************/

directory(dir_name,mask)
char *mask,*dir_name;
{
register int i,j;
register unsigned char *tmp;
char temp[15];
static char my_dir_name[40];
register int key;	
int old_attrib,done;

#ifdef TURBO
struct ffblk ffblk;
#endif

	  old_attrib=scr_getatr();             /* save current attribs */
	  cursor(OFF);

	  /* open dir window */

	  i=make_window(2,10,12,60,dir_window,dir_border,doubl);
	
          for(i=0;*(dir_name+i)!='\0';i++)
             my_dir_name[i+1]=toupper(*(dir_name+i));

          my_dir_name[0]=my_dir_name[++i]=' ';
          my_dir_name[++i]='\0';
          title_window(left,&my_dir_name[0],w[li].wsbattr,TOP);
	  title_window(center," F1 - Help | ESC - Exit | / - Menu ",\
                       w[li].wsbattr,BOT);

  	  start_row=w[li].wsrow+1;
	  end_row=start_row+w[li].wsrows-3;
	  start_col=w[li].wscol+1;
	  end_col=start_col+w[li].wscols;
	  width=end_col - start_col;
	  num_cols=width/13;

          if((num_cols*13)>w[li].wscols)
             --num_cols;

	  start_col=start_col+((w[li].wscols-(13*num_cols))/2);
	  culor=w[li].wswattr;
	  hcolor=swap(w[li].wswattr); /* gen highlight bar attribute */


	  qwritecv(start_row+(w[li].wsrows/2)-1,start_col,end_col,\
                  culor,"Reading directory ...");

	  /* read the directory */

	   i=0;
#ifdef TURBO
           done=findfirst(mask,&ffblk,0);
           while(!done && i<DIR_MAX) {
              dir_ptr=&ffblk.ff_name;
#else
	   while((dir_ptr=scdir(mask)) && (i<DIR_MAX)){
#endif
		if(*dir_ptr=='.') { /* ignore parent and sibling entry */
#ifdef TURBO
		  done=findnext(&ffblk);
#endif
                  continue;
                }

                tmp=dir_ptr;

                for(j=0;j<13;j++)
                   temp[j]=' ';

                temp[8]='.';

                /* up case and blank-fill the filename */

                for(j=0;(*tmp!='.' && *tmp!='\0');j++,tmp++)
                   temp[j]=toupper((char)*tmp);

                if(*tmp=='.')
                   temp[8]=*tmp++;

		if(*tmp!='\0')
                  for(j=9;*tmp!='\0';j++,tmp++)
                     temp[j]=toupper((char)*tmp);

                temp[12]='\0';
                if(temp[9]==' ')
                   temp[8]=' ';

                /* now stuff it in table */

		strcpy(&dir_list[i++][0],&temp[0]);
#ifdef TURBO
		done=findnext(&ffblk);
#endif

           } /* end while */

           /* directory has been read at this point */

	for(j=1;j<4;j++)
           count_title[j]=' '; /* build entry count title */
	
	my_itoa(i,&count_title[1]);
        for(j=1;j<4;j++)
           if(count_title[j]>' ')
              break;
	
        /* place entry count title on top right border */

        title_window(right,&count_title[--j],w[li].wsbattr,TOP);
		
	max=i;
        qwritecv(start_row+(w[li].wsrows/2),start_col,end_col,\
                 culor,"Sorting directory ...");       

	sort(i-1); /* guess what? */
	clr_window(culor,' ');
	scr_echo(0); /* keyboard echo off */
	home_it();   /* start cursor in upper left of window (1st file) */
        last_indx=255;
        refresh();   /* show initial screen */

	while((key=(int)tolower(scr_getc()))!=0x1b) { /* esc will end */

	  switch(key) {

	  case (int)'/':
                        menu();
                        title_window(left,&my_dir_name[0],w[li].wsbattr,TOP);
                        for(j=1;j<4;j++)
                          if(count_title[j]>' ')
                          break;
                        title_window(right,&count_title[--j],\
                                     w[li].wsbattr,TOP);
                        continue;

	  case HELP:    toggle_help();
			continue;

    	  case cursor_up:
                        move_up();
                        refresh();
                        continue;

	  case cursor_dn:
                        move_dn();
                        refresh();
                        continue;

          case cursor_lf:
                        move_lf();
                        refresh();
                        continue;

          case cursor_rt:
                        move_rt();
                        refresh();
                        continue;

 	  case page_up:
                        move_pg_up();
                        refresh();
                        continue;

	  case page_dn:
                        move_pg_dn();
                        refresh();
                        continue;

	  case home:
                        home_it();
                        refresh();
                        continue;

	  case end:
                        move_end();
                        refresh();
                        continue;

	  case cr:      dir.key=key;
                        dir.indx=hl;
                        if(help_flag!=0) {
                          toggle_help();
                          remove_window();
                        }
                        else {
                          remove_window();   
                        }
                        cursor(ON);
                        scr_resatr(old_attrib);
                        return(0);

          default:      beep();

	} /* end switch */            

      } /* end while */

       if(help_flag!=0) {
         toggle_help();
         remove_window();
       }
       else {
         remove_window();   
       }
        dir.key=key;
        dir.indx=hl;
        scr_echo(1); /* echo on */
        cursor(ON);
        scr_resatr(old_attrib);
        return(0);

} /* end of dir() */

/*****************************************************************************
 * menu() handles the function menu for the directory lister.  It calls      *
 * all handlers for the various functions that are/will be supported. If you *
 * add or change the functions be sure to modify the code.                   *
 ****************************************************************************/

menu()
{
register int menu_hl,menu_hcolor,menu_key;

	close_top_border();
	set_menu_color();
	menu_hl=1;
	menu_hcolor=mcolor[1]=swap(w[li].wsbattr);
	write_menu();

	scr_echo(0);
	while((menu_key=(int)tolower(scr_getc()))!=0x1b) { /* esc will end */

           switch(menu_key) {

     	     case cursor_lf:
                          --menu_hl;
                          if(menu_hl<1)
                             menu_hl=3;
                          set_menu_color();
                          mcolor[menu_hl]=menu_hcolor;
                          break;

	     case cursor_rt:
                          ++menu_hl;
                          if(menu_hl>3)
                            menu_hl=1;
                          set_menu_color();
                          mcolor[menu_hl]=menu_hcolor;
                          break;

	     case cr: if(menu_hl==1) {
                        close_top_border();
                        cursor(OFF);
                        return;
                      }
                      else {
                        if(menu_hl==2) {
                           rename_file();
                           scr_echo(0);
                           continue;
                        }
                        if(menu_hl==3) {
                          delete_file();
                          scr_echo(0);
                          continue;
                        }
                        continue;

                      } /* end else */

 	     case HELP:    toggle_help();
	   		   continue;

    	     case cursor_up:
                           move_up();
                           refresh();
                           continue;

	     case cursor_dn:
                           move_dn();
                           refresh();
                           continue;

    	     case page_up:
                           move_pg_up();
                           refresh();
                           continue;

	     case page_dn:
                           move_pg_dn();
                           refresh();
                           continue;

	     case home:
                           home_it();
                           refresh();
                           continue;

	     case end:
                           move_end();
                           refresh();
                           continue;


	     default: beep();
                      continue;

	   } /* end switch */

	write_menu();

        } /* end while */

	close_top_border();
        cursor(OFF);

} /* end of menu() */

/****************************************************************************
 * low level prim for directory menu handler                                *
 ***************************************************************************/

write_menu()
{

        qwrite(2,20,mcolor[1]," CANCEL ");
        qwrite(2,37,mcolor[2]," RENAME ");
	qwrite(2,54,mcolor[3]," DELETE ");

} /* end of write_nume() */

/*****************************************************************************
 * low level prim for directory menu handler                                 *
 ****************************************************************************/

set_menu_color()
{

	mcolor[1]=mcolor[2]=mcolor[3]=w[li].wsbattr;

} /* end of set_menu_color() */

/*****************************************************************************
 * close_top_border() redraws a fresh top border on the directory window     *
 ****************************************************************************/

close_top_border()
{
        qwritev(w[li].wsrow,w[li].wscol,w[li].wsbattr,u_l_corner);         
	qfill(w[li].wsrow,w[li].wscol+1,1,w[li].wscols-2,\
              w[li].wsbattr,h_bar);     
	qwritev(w[li].wsrow,w[li].wscol+w[li].wscols-1,\
                w[li].wsbattr,u_r_corner);

} /* end of close_top_border() */

/*****************************************************************************
 * delete_file() deletes the file currently pointed to by hl.                *
 ****************************************************************************/

delete_file()
{
char c;
        
	close_top_border();
        strncpy(&confirm[14],&dir_list[hl][0],strlen(&dir_list[hl][0]));
        title_window(left,&confirm[0],w[li].wsbattr,TOP);
        beep();
        scr_curs(w[li].wsrow,w[li].wscol+strlen(&confirm[0])+1);
        scr_setatr((w[li].wsbattr&0xf000)>>8,w[li].wsbattr&0x0f,\
                    HIGH,NO_BLINK);
	c=' ';
        while(c!='Y' && c!='N' && c!=27)
            c=toupper(scr_getc());

        scr_putc(c);

        if(c=='Y') {
          unlink(&dir_list[hl][0]);
          pack();
        }
        else {
          close_top_border();  
          beep();
          title_window(left," Operation Cancelled ",w[li].wsbattr,TOP);
          beep();
          delay(32000);
        }
        close_top_border();
        write_menu();         

} /* end of delete_file() */

/******************************************************************************
 * pack() packs the directory array after a deletion has occured.             *
 *****************************************************************************/

pack()
{
register int i;

	for(i=hl;i<max+1;i++) 
           strcpy(&dir_list[i][0],&dir_list[i+1][0]);

        --max;

        if(hl>max)
           hl=max;

        if(last_hl>max)
           last_hl=max;

	last_indx=255; /* force refresh to update the screen */
	refresh();

} /* end of pack() */

/*****************************************************************************
 * rename_file does just that ...                                            *
 *****************************************************************************/

rename_file()
{
register int i,j,loop;
char *s;
static char myname[14],temp[14];
register char *tmp;

	loop=TRUE;

        while(loop==TRUE) {
  	  close_top_border();
          title_window(left,&new_name[0],w[li].wsbattr,TOP);
          scr_curs(w[li].wsrow,w[li].wscol+13);
          scr_echo(1);        /* echo on */
          cursor(ON);         /* show cursor */
	  get_ansi_color(w[li].wsbattr); /* set system color */
	  for(i=0;i<10;i++)
	    putchar(ansi_seq[i]);  /* was printf("%s",&ansi_seq[0]); */

          s=gets(&buf[0]); /* get the new name */
          i=0;

	  /* transfer name and upcase it ... */

          while( (myname[i++]=toupper(*s++)) > ' ') {
            ; /* null stmt */
          }
          myname[i]='\0';

	  /* if it was null or cr exit */

	  if(myname[0]=='\0' || myname[0]==13) {
             close_top_border();
             beep();
             title_window(left," Operation Cancelled ",w[li].wsbattr,TOP);
             beep();
             delay(32000);
             close_top_border();
             write_menu();
	     scr_echo(0);
             cursor(OFF);
             return;
          }

	  /* if rename fails scream at operator (not really) and loop */

          if(rename(&dir_list[hl][0],&myname[0])== -1) {
            beep();
            beep();
            beep();
          }
          else
            loop=FALSE;

        } /* end while */

	tmp=&myname[0];

        for(j=0;j<13;j++) 
           temp[j]=' ';
            
        temp[8]='.';

        /* up case and blank-fill the filename */

        for(j=0;(*tmp!='.' && *tmp!='\0');j++,tmp++) 
          temp[j]=toupper((char)*tmp);

        if(*tmp=='.')
          temp[8]=*tmp++;

        if(*tmp!='\0')
          for(j=9;*tmp!='\0';j++,tmp++)
            temp[j]=toupper((char)*tmp);
                
        temp[12]='\0';

        if(temp[9]==' ')
           temp[8]=' ';

        /* now stuff it in table */
                
        strcpy(&dir_list[hl][0],&temp[0]);

        close_top_border(); /* clear prompt */
        write_menu();       /* rewrite menu */
	scr_echo(0);        /* no keyboard echo */
        cursor(OFF);        /* make cursor invisible */
        sort(max-1);        /* resort the array after a file was renamed */
        last_indx=255;      /* force refresh to update screen */
	refresh();

} /* end of rename_file() */

/*****************************************************************************
 * toggle_help() handles the directory help screen window.                   *
 ****************************************************************************/

toggle_help()
{
register int i;

	if(help_flag!=0) {
	  ++li;
          remove_window();
          help_flag=0;
          return;
        }
        else {                       /*          these should be defines */
	  i=make_window(w[li].wsrow+w[li].wsrows-1,10,8,60,dir_window, \
			dir_border,doubl);
          if(i!=0) {
            scr_curs(22,1);
            scr_printf("Failed to make help window - code %x ",i);
            return;
          }
          help_flag=li;
          qwritev(w[li].wsrow,w[li].wscol,w[li].wsbattr,left_tee);
          qwritev(w[li].wsrow,w[li].wscol+w[li].wscols-1,w[li].wsbattr,\
                  right_tee);
	  title_window(center," F1 - Cancel Help | ESC - Exit | / - Menu ",\
                       w[li].wsbattr,TOP);
          for(i=0;i<6;i++) 
            qwritecv(w[li].wsrow+1+i,w[li].wscol,w[li].wscol+w[li].wscols,\
                     w[li].wswattr,help_line[i]);
          --li;
        }

} /* end of toggle_help() */

/****************************************************************************
 * the next 4 routines handle cursor movements within a page.  Wrap around  *
 * automagically handled on a page basis only (i.e., no file wrap-around).  *
 ***************************************************************************/

move_lf()
{
	lasthl=hl;
	--hl;
	if(hl<first_hl)
           hl=last_hl-1;

	if(hl>max)
           hl=max;

} /* end of move_lf() */

move_rt()
{
	lasthl=hl;
	++hl;
	if(hl>last_hl-1 || hl>max)
           hl=indx;
 
} /* end of move_rt() */

move_dn()
{
	lasthl=hl;
	++hl;
	if(hl>last_hl-1 || hl>max)
           hl=indx;
	
} /* end of move_dn() */

move_up()
{
	lasthl=hl;
	--hl;
	if(hl<first_hl)
           hl=last_hl-1;

} /* end of move_up() */

/****************************************************************************
 * home() homes the cursor in 2 ways.  1 if not at home already, home page  *
 * only. If at home already, home file.                                     *
 ***************************************************************************/

home_it()
{

	lasthl=hl;
	if(indx!=0 && hl==first_hl) {
          hl=indx=first_hl=0;
	  return;
        }

	if(indx!=0 && hl!=first_hl) {
          hl=first_hl;
  	  return;
	}
	else {
   	  indx=hl=first_hl=0;
          return;
        }

} /* end of home_it() */

/*****************************************************************************
 * move pointer forward 1 page.                                              *
 ****************************************************************************/

move_pg_dn()
{
        lasthl=hl;
	if((max<40) || ((indx+40)>max) || ((indx+40)==max))
           return; /* if only 1 page in entire list ignore request */

	indx+=40; /* bump pointer at next log page */
        hl+=40;

	if(hl>max-1) /* if past end of list use endlist-40 as page */
          hl=max-1;

        if(indx>max) {
          indx=max-40;
          hl=max-40; 
        }

} /* end of move_pg_up() */

move_pg_up()
{

	lasthl=hl;
	if(max<40) /* less than 1 page in entire list? */
          return;  /* yes ... */

	indx-=40; /* else back off pointer 1 page */
        hl-= 40;

        if(indx<0) { /* redundant error trapping */
          indx=0;
          hl=0;
        }
} /* end of move_pg_up() */

/*****************************************************************************
 * move_end() handles moving to the end of the directory list.               *
 ****************************************************************************/

move_end()
{
	lasthl=hl;
	if(max<40)
           return;

	indx=max-40;
        hl=max-40;

	if(indx<0)
          hl=indx=0;

} /* end of move_end() */

/**************************************************************************** 
 * refresh() handles the screen (panel) refresh for the directory handler.  *
 ***************************************************************************/

refresh()
{

	if(indx!=last_indx) {
           clr_window(culor);
	   show_panel(start_row,start_col,end_row,num_cols,culor,indx,max);
           highlight_on();
           last_indx=indx;
        }
        else {
           highlight_off();
	   highlight_on();
        }

} /* end of refresh() */

/**************************************************************************** 
 * highlight_on() finds and displays the filename currently under the       *
 * psuedo-cursor.  The name is displayed in reverse attributes.             *
 ***************************************************************************/

highlight_on()
{
int j,k;
int i,x;

        for(k=0,j=start_col,x=indx;(k<num_cols && x<last_hl+1);j+=13,k++) 
           for(i=start_row;((x<last_hl+1) && (i<end_row+1));x++,i++) 
              if(x==hl) {
                qwrite(i,j,hcolor,&dir_list[x][0]); 
                return;
             }
        scr_curs(22,1);
        scr_printf("Runtime error in module highlight_on x=%d hl=%d ",x,hl);
        scr_getc();
        exit(0); /* halt the system */ 

} /* end of highlight_on() */


/**************************************************************************** 
 * highlight_off() finds and displays the filename currently under the      *
 * psuedo-cursor.  The name is displayed in normal attributes.              *
 ***************************************************************************/

highlight_off()
{
int j,k;
int i,x;

        for(k=0,j=start_col,x=indx;(k<num_cols && x<last_hl+1);j+=13,k++) 
           for(i=start_row;((x<last_hl+1) && (i<end_row+1));x++,i++) 
              if(x==lasthl) {
                qwrite(i,j,swap(hcolor),&dir_list[x][0]); 
                return;
             }
        scr_curs(22,1);
        scr_printf("Runtime error in module highlight_off x=%d hl=%d ",x,hl);
        scr_getc();
        exit(0); /* halt the system */ 

} /* end of highlight_off() */

/***************************************************************************
 * show_panel displays 1 panel of the directory list.                      *
 **************************************************************************/
		        
show_panel(startrow,startcol,endrow,numcols,colr,buf,max)
int startrow,startcol,endrow,numcols,colr,max,buf;
{
register i,j,k,x;

           for(k=0,j=startcol,x=buf;(k<numcols && x<max);j+=13,k++) 
             for(i=startrow; i<endrow+1 &&x<max ;x++,i++) 
                qwrite(i,j,colr,&dir_list[x][0]); 

           first_hl=buf; /* set first and last bounds */
           last_hl= x;
	
} /* end of show_panel() */

/*****************************************************************************
 * Sort() sorts a character array using a SHELL sort algorythmn.             *
 ****************************************************************************/

sort(num)
unsigned num;    /* number of elements in array */

{
register int spread, i, j, l;

        spread=num>>1;
        while(spread>0) {
          for(i=spread; i<num+1; i++) {
             j=i-spread;

             while(j>-1) {
               l=j+spread;

               if(strcmp(&dir_list[j][0],&dir_list[l][0])<0)
                  j=-1;
               else
                  swtch(j,l);

               j=j-spread;
               } 
           } 
          spread=spread>>1;
         }
 
} /* end of sort */

/****************************************************************************
 * swtch is the element switcher used by the shell sort.                    *
 ***************************************************************************/

swtch(jj,ll)
register unsigned jj,ll;
{
static char temp[15];

        strcpy(&temp[0],&dir_list[jj][0]);
        strcpy(&dir_list[jj][0],&dir_list[ll][0]);
        strcpy(&dir_list[ll][0],&temp[0]);

} /* end of swtch */

/* end of module dir.c */
