
 /***************************************************************************
 * This file contains the declarations for the window support routines.     *
 * See WINDOW.DOC for documentation on how to use the various functions.    *                                               *
 *                                                                          *
 * Modification History: 061787 - original release DLM.                     *
 *                       081387 - added additional storage in window        *                                                   *
 *                                array. Also added qwrited/qwritef         *
 *                                functions to write double/float numbers   *
 *                       092487 - Field width added to qwritef() & qwrited()*
 *                                Border types implemented.  DLM            *
 ***************************************************************************/

#define TURBO

#ifdef TURBO
#include "dos.h"
#include "mem.h"
#endif

#include "stdio.h"
#include "color.h"
#include "gchars.c" /* defs for graphics chars */
#include "ctype.h"  /* contains macros isalpha, toupper , etc */

#define FALSE 0        /* falsehood */
#define TRUE 1         /* truth */
#define MAYBE 1/2      /* life */
#define UP 1
#define DN 2
#define RT 3
#define LF 4

#define TOP 0          /* flags for where to place window titles top/bottom */
#define BOT 1
#define OFF 0
#define ON  1

               /* direction types for use with shadowing, etc. */

#define      nodir 1
#define         up 2
#define       down 3
#define        top 5
#define       left 6
#define      right 10
#define     center 12

#define DIR_MAX 200          /* max directory entries we can process
                                - set as needed */
#define maxwndw 30          /* max number of windows allowed */

/* 12 possible border types */

typedef enum {  doubl,blank,singl,mixed,solid,
		evensolid,thinsolid,lhatch,mhatch,
		hhatch,user,nobrdr} borders;

#define TLC 0
#define THC 1
#define TRC 2
#define LVC 3
#define RVC 4
#define BLC 5
#define BHC 6
#define BRC 7


extern char brdr[12][8];
/*

     example of the types of borders possible with the above table

     (   ' '    ' '    ' '    ' '    ' '    ' '    ' '    ' '    { none      }
     (   ' '    ' '    ' '    ' '    ' '    ' '    ' '    ' '    { Blank     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Single    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Double    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Mixed     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Solid     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { EvenSolid }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { ThinSolid }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Lhatch    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Mhatch    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Hhatch    }
     (   '*'    '*'    '*'    '*'    '*'    '*'    '*'    '*'    { User      }

*/

extern double round[20];

/*****************************************************************************
 * the following are the variables that are modifiable from your application *
 * i.e., they are defined as external in WINDOW.H                            *
 ****************************************************************************/

extern int  shadow_effect;   /* direction of shadow use nodir if no shadow*/
extern char zoom_effect;    /* zoom on/off flag use FALSE if no zoom wanted */
extern int  zoom_delay;      /* delay when zooming - adjust to taste */
extern int  shadow_attr;   /* color of shadow - whatever looks good to you */
extern int  dir_border;
extern int  dir_window;
extern char clear_char;      /* char to clear windows with - alterable */

extern unsigned char  *wndwptr[maxwndw];   /*  pointers to windows on heap  */
extern int            li, licurrent;       /*  level index, level index for
                                               swapping windows  */

/* this array defines the various stuff for each of 1 - maxwndw possible
   windows. */

extern struct {
             int      wsrow, /* top left row of window */
                      wscol, /* top left column */
                     wsrows, /* number of rows in this window */
                     wscols, /* number of columns */
                    wswattr, /* window attribute */
                    wsbattr; /* border attribute */
	 borders     wsbrdr; /* border type */
         int       wsshadow; /* direction of shadow if employed */
         int        wslastx, /* last row and */
		    wslasty; /* and column position of cursor in this window */
	 int       x2,x3,x4; /* some additional storage - use as you see fit */
	 int       y2,y3,y4; /* same - ideal for addtional cursor coords */
         int       orig_row, /* original row where window was opened */
                   orig_col; /*     "    col   "      "    "    "    */

               }  w[maxwndw];

extern char ansi_seq[];      /* for gening ansi escape sequences */

extern struct {
       char key;    /* holds last key pressed in directory handler */
        int indx;   /* index into dir_list[] of selected filename */
       } dir;       /* i.e., index of name selected. */


/** end of variables global to your code */

/*****************************************************************************/

/* cursor key definitions */

#define cursor_up 0xc8
#define cursor_dn 0xd0
#define cursor_rt 0xcd
#define cursor_lf 0xcb
#define home      0xc7
#define end       0xcf
#define page_up   0xc9
#define page_dn   0xd1
#define cr        0xd
#define HELP      0xbb

unsigned char *malloc();
unsigned char *qsave();
#ifndef TURBO
unsigned char *scdir();
#endif
char *gets();
void get_addr();

extern unsigned int page_seg;              /*  segment of video matrix */
extern int vmode,card_wait,
    max_page,qseg,qwait;            /* work vars for window routines */
extern unsigned char *kill_flag;
extern unsigned char *ptr;
extern int cur_lin,cur_col;                /* cursor tracking storage */
extern char buf[80];                       /* buffer for screen title
                                              strings */
extern int tattr;                        /* attribute */
extern char *help_line[6];
extern char count_title[];
#ifdef TURBO
extern char *dir_ptr;
#else
extern unsigned char *dir_ptr;       /* dir stuff */
#endif

/* misc usage */

extern unsigned char *killflag,*orig;
extern int hl,lasthl,first_hl,last_hl,last_indx;
extern int help_flag;
extern int mcolor[4];
extern char confirm[37];
extern char new_name[45];
extern int start_row;
extern int end_row;
extern int start_col;
extern int end_col;
extern int culor;
extern int hcolor;
extern int max;
extern int width;
extern int num_cols;
extern int indx;
extern char *vid_ram;

#ifdef TURBO
extern _attrib,_echo;
extern union REGS regs;
#endif

/* end of definitions necessary for window pkg. */

