
/*****************************************************************************
 * This file contains all the variable stuff for use with WINDOW.C.          *
 * This is the quy to 'include' in your application.                         *
 * Modification history:                                                     *
 *                        061787 - Original release - DLM.                   *
 *                        081387 - Added storage to window array (6 ints)    *
 *                                 Added qwritef/qwrited to write float &    *
 *                                 doubles to screen - DLM.                  *
 *                        082687 - Added fg/bg color variables for directory *
 *                                 Color of directory window (both border &  *
 *                                 text inside are now user selectable - DLM *
 *                        092487 - Implemented border types - DLM            *
 *                                 Character used to clear windows is now    *
 *                                 alterable via the extern clear_char.      *
 *                                 Field width (both fractional & integer)   *
 *                                 of floats and doubles is now specified.   *
 ****************************************************************************/

#define FALSE 0        /* falsehood */
#define TRUE 1         /* truth */
#define MAYBE 1/2      /* life */

#define TOP 0          /* flags for where to place window titles top/bottom */
#define BOT 1
#define OFF 0          /* flags for cursor on/off */
#define ON  1

               /* direction types for use with shadowing */

#define      nodir 1
#define         up 2
#define       down 3
#define        top 5
#define       left 6
#define      right 10
#define     center 12


/*****************************************************************************
 * the following are the variables that are most likely to need redefining   *
 * for your application.                                                     *
 ****************************************************************************/

extern int shadow_effect;  /* direction of shadow use nodir if no shadow*/
extern char zoom_effect;   /* zoom on/off flag use FALSE if no zoom wanted */
extern int  zoom_delay;    /* delay when zooming - adjust to taste */
extern int  shadow_attr;   /* color of shadow - whatever looks good to you */

/* new for 092487 - DLM */

extern char clear_char;    /* char to clear windows with - alterable */
extern char *vid_ram;


/* new for 082687 - DLM */

extern int  dir_border;    /* color of directory lister border (default is
			      blue foreground/cyan background) */
extern int  dir_window;    /* color of text inside directory window (default is
			      white foreground/black background) */

/*****************************************************************************/

/* 12 possible border types */
/* implementation as of 092487 - dlm */

 #define doublebrdr 0
 #define blankbrdr  1
 #define singlebrdr 2
 #define mixedbrdr  3
 #define solidbrdr  4
 #define evensolidbrdr 5
 #define thinsolidbrdr 6
 #define lhatchbrdr    7
 #define mhatchbrdr    8
 #define hhatchbrdr    9
 #define userbrdr      10
 #define nobrdr        11

 /*

     example of the types of borders possible with the above table

	top     top   top     left   right  bot   bot    bot
       right   line   left    vert   vert   left  line   right

     (   ''    ''    ''    ''    ''    ''    ''    ''    { Double    }
     (   ' '    ' '    ' '    ' '    ' '    ' '    ' '    ' '    { Blank     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Single    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Mixed     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Solid     }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { EvenSolid }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { ThinSolid }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Lhatch    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Mhatch    }
     (   ''    ''    ''    ''    ''    ''    ''    ''    { Hhatch    }
     (   '*'    '*'    '*'    '*'    '*'    '*'    '*'    '*'    { User      }
     (   ' '    ' '    ' '    ' '    ' '    ' '    ' '    ' '    { none      }

     set brdr[11][0-7] to whatever to redefine the user border defs

*/


extern unsigned char  *wndwptr[];        /*  pointers to windows on heap  */ 
extern int            li, licurrent;     /*  level index, level index for
                                               swapping windows  */ 

/* this array defines the various stuff for each of 1 - maxwndw possible 
   windows. maxwndw currently set at 30. Edit & recompile wind.c to change */

extern struct { 
             int      wsrow, /* top left row of window */
                      wscol, /* top left column */
                     wsrows, /* number of rows in this window */
                     wscols, /* number of columns */
                    wswattr, /* window attribute */
                    wsbattr; /* border attribute */
	 int         wsbrdr; /* border type */
         int       wsshadow; /* direction of shadow if employed */
         int        wslastx, /* last row and */
		    wslasty; /* and column position of cursor in this window */
	 int       x2,x3,x4; /* some additional storage - use as you see fit */
	 int       y2,y3,y4; /* same - ideal for addtional cursor coords.  */
			     /* NOTE: if using these to store cursor coords
				      the convention is that x=cols and
				      y=rows (Cartesian coord system). */
         int       orig_row, /* original row where window was opened */
                   orig_col; /*    "     col   "     "     "    "    */

               }  w[];

extern char dir_list[200][13];            /* array for directory names */
extern unsigned char all_files[];         /* search mask for dir handler */
extern char ansi_seq[];                   /* used by get_ansi_color() */
extern unsigned char *qsave();
extern void get_addr();
extern unsigned int page_seg;
extern char brdr[12][8];
extern int vmode;

/*****************************************************************************
 * This is where directory() returns information to your application         *
 ****************************************************************************/

extern struct {
       char key;    /* holds last key pressed in directory handler */
        int indx;   /* index into dir_list[] of selected filename */
       } dir;       /* i.e., index of name selected. */

/* end of definitions necessary for window.lib */
