#include "char.h"
#include "common.h"
#include "display.h"
#include "editor.h"
#include "file.h"
#include "fgdemo.h"
#include "menu.h"
#include "misc.h"
#include "fundmtls.h"
#include "utility.h"
#include "video.h"

#include <ctype.h>
#include <dos.h>
#include <fastgraf.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef   __TURBOC__
#include <alloc.h>
#else
#include <malloc.h>
#endif

#define BETWEEN(x,a,b) ((x >= a) && (x <= b))
#define MAX(x,y) ((x) > (y)) ? (x) : (y)
#define MIN(x,y) ((x) < (y)) ? (x) : (y)

#define PAGES 2

#define OFF   0
#define ON    1

#define ERR  -1
#define OK    1

#define FALSE 0
#define TRUE  1

#define ASCII        0
#define ALPHANUMERIC 1

#define BS           8
#define CR          13
#define ESC         27
#define SPACEBAR    32

#define UP_ARROW    72
#define DOWN_ARROW  80
#define LEFT_ARROW  75
#define RIGHT_ARROW 77

#define HOME        71
#define PAGE_UP     73
#define END         79
#define PAGE_DOWN   81

#define INSERT      82
#define DELETE      83

#define ITEMS 6  /* number of items on main menu */

extern char string[];

extern int mode06;
extern int mode11;
extern int mode14;
extern int mode16;

extern int mode06_avail;
extern int mode11_avail;
extern int mode14_avail;
extern int mode16_avail;

extern int background;
extern int buttons;
extern int hidden, visual;
extern int mouse;
extern int old_mode, mode;
extern int ptsize;
extern int redraw;
extern int xlimit, ylimit;
extern int xmouse, ymouse;
extern int mouse_limits[];
extern int mouse_limits[];

extern int menu_top;
extern int menu_bottom;

extern char matrix1[];  /* dither patterns */
extern char matrix2[];

typedef int (*PFI)();   /* pointer to an integer function */

/* command structure */

typedef struct cmd
{
   PFI menu_func;       /* function to carry out the command */
   char *menu_item;     /* the menu item as written on the screen */
   int x1;              /* coordinates of location of menu_item */
   int x2;
   int next;
   int prev;
}  CMD;

extern CMD main_menu[];
