/**********************************************************************\
*                                                                      *
*  display.c -- graphics display functions, bitmaps, scrolling, etc.   *
*                                                                      *
\**********************************************************************/

#include "defs.h"
#include "tntmaps.h"

/**********************************************************************\
*                                                                      *
*  do_bitmaps -- display some bitmaps on the screen                    *
*                                                                      *
\**********************************************************************/

do_bitmaps()
{

   /* width, height, position and colors of TNT plunger bitmap */

   static int tnt_width[]   = { 6,  3,  4,  4};
   static int tnt_height[]  = {28, 25, 27, 17};
   static int tnt_color[]   = { 0,  7,  8, 15};
   static int tnt_xoffset[] = { 0, 24, 16, 16};
   static int tnt_yoffset[] = { 0, -2, -1, -2};
   static char *tnt_bitmap[4] = {tnt0,tnt7,tnt8,tnt15};

   /* width, height, position and colors of "kablooy" explosion */

   static int kablooy_width[]   = {13,  6};
   static int kablooy_height[]  = {53,  8};
   static int kablooy_color[]   = { 4, 15};
   static int kablooy_xoffset[] = { 0, 29};
   static int kablooy_yoffset[] = { 0,-24};
   static char *kablooy_bitmap[2] = {kablooy4,kablooy15};

   /* strings for info window */

   static char *string[] = {
   "Bitmaps",
   "Bitmaps can be clipped, flipped, mode-independent",
   "and mode-specific.",
   };

   register int i;
   int x,y;
   int ymin,ymax;

   /* clear lower part of screen */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* display the info window */

   info_window(120,520,60,string,3);

   /* calculate where the TNT bitmap is going to go */

   ymin = scale(60);
   ymax = ymin + 4 * (ptsize+1);

   x = 520;
   y = ymax;

   /* put the TNT bitmap next to the info window */

   fg_mousevis(OFF);
   for (i = 0; i < 4; i++)
   {
      fg_move(x+tnt_xoffset[i],y+tnt_yoffset[i]);
      fg_setcolor(tnt_color[i]);
      fg_drawmap(tnt_bitmap[i],tnt_width[i],tnt_height[i]);
   }

   /* save info window to hidden page, to be replaced after the explosion */

   x = 440;
   y = ymax + 20;
   fg_save(400,520,ymin,y);

   /* take a rectangular bite out of the info window on the hidden page */

   fg_transfer(464,568,144,180,464,y-10,hidden,hidden);

   /* pause 1 second */

   fg_mousevis(ON);
   fg_waitfor(18);

   /* move the plunger down */

   fg_mousevis(OFF);
   fg_transfer(544,567,ymax-30,ymax-25,544,ymax-23,visual,visual);
   fg_mousevis(ON);
   fg_waitfor(6);

   fg_mousevis(OFF);
   fg_transfer(544,567,ymax-28,ymax-23,544,ymax-21,visual,visual);
   fg_mousevis(ON);
   fg_waitfor(6);
   fg_mousevis(OFF);

   /* display the explosion */

   for (i = 0; i < 2; i++)
   {
      fg_move(x+kablooy_xoffset[i],y+kablooy_yoffset[i]);
      fg_setcolor(kablooy_color[i]);
      fg_drawmap(kablooy_bitmap[i],kablooy_width[i],kablooy_height[i]);
   }

   /* blink the "kablooy" text 4 times */

   for (i = 0; i < 4; i++)
   {
      fg_waitfor(3);
      fg_move(x+kablooy_xoffset[1],y+kablooy_yoffset[1]);
      fg_setcolor(4);
      fg_drawmap(kablooy_bitmap[1],kablooy_width[1],kablooy_height[1]);
      fg_waitfor(3);
      fg_move(x+kablooy_xoffset[1],y+kablooy_yoffset[1]);
      fg_setcolor(15);
      fg_drawmap(kablooy_bitmap[1],kablooy_width[1],kablooy_height[1]);
   }

   /* wait a bit, then restore the info window with the corner missing */

   fg_waitfor(3);
   fg_restore(440,568,y-68,y);

   /* draw the torn edges of the info window using the tear bitmap */

   fg_setcolor(0);
   fg_move(461,ymax);
   fg_drawmap(tear,8,29);

   /* restore all the stuff on the hidden page */

   draw_screen();

   /* wait for a keystroke, restore the visual page, and return */

   fg_mousevis(ON);
   wait_for_keystroke();

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_scroll -- do a circular scroll of part of the screen             *
*                                                                      *
\**********************************************************************/

do_scroll()
{
   register int i;
   int y1,y2;

   y1 = scale(4);
   y2 = ylimit - y1;

   fg_mousevis(OFF);

   /* save the area under the scroll */

   fg_transfer(280,439,y1,y2,0,y2,hidden,hidden);

   /* do a nice circular scroll */

   for (i = y1; i <= y2; i+=2)
      fg_scroll(280,439,y1,y2,-2,0);

   /* fix the area under the scroll */

   fg_transfer(0,159,y1,y2,280,y2,hidden,hidden);
   fg_save(0,159,y1,y2);

   fg_mousevis(ON);
   return(OK);
}

/**********************************************************************\
*                                                                      *
* do_transfer -- demo the transfer function                            *
*                                                                      *
\**********************************************************************/

do_transfer()
{
   register int i;
   int x,y;
   int ymin,ymax;

   static char *string[] = {
   "Transfer",
   "Use Fastgraph's image transfer routines",
   "to copy rectangular areas, either on the",
   "same video page or different video pages."
    };

   /* clear work area of visual page and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(24,419,60,string,4);

   /* save the info window to the hidden page */

   ymin = scale(60);
   ymax = ymin + 5 * (ptsize+1) + 2;
   fg_save(24,419,ymin,ymax);

   /* transfer a 6 copies of the info window from hidden page to visual */

   x = 56;
   y = ymax+ptsize+1;
   for (i = 0; i < 6; i++)
   {
      fg_transfer(24,419,ymin,ymax,x,y,hidden,visual);
      x += 32;
      y += ptsize;
      fg_waitfor(2);
   }

   /* wait for a keystroke */

   fg_mousevis(ON);
   wait_for_keystroke();

   fg_mousevis(OFF);

   /* clear the area where the info window was on the hidden page */

   y = 5 * (ptsize+1) + 2;

   fg_transfer(24,419,ymax+1,ymax+y+1,24,ymax,hidden,hidden);

   /* restore the screen and return */

   fg_restore(0,xlimit,menu_bottom,ylimit);
   redraw = TRUE;

   fg_mousevis(ON);
   return(OK);
}

/**********************************************************************\
*                                                                      *
*  view_pcx -- display an image from a PCX file                        *
*                                                                      *
\**********************************************************************/

view_pcx()
{
   register int i, j;
   int red, green, blue;

   static int RGBdefaults[] = {
       0, 0, 0,  0, 0,42,  0,42, 0,  0,42,42,
      42, 0, 0, 42, 0,42, 42,21, 0, 42,42,42,
      21,21,21, 21,21,63, 21,63,21, 21,63,63,
      63,21,21, 63,21,63, 63,63,21, 63,63,63};
   
   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* display the image, ignoring palettes in two-color mode */

   fg_erase();
   fg_setcolor(0);
   fg_move(0,0);
   if (mode06)
      fg_disppcx("CASINO.PCX",1);
   else
      fg_disppcx("CASINO.PCX",0);

   /* restore the hidden page */

   draw_screen();

   /* wait for a keystroke */

   fg_mousevis(ON);
   wait_for_keystroke();
   fg_mousevis(OFF);

   /* before we restore the palettes, erase the visual page */

   fg_erase();
   if (mode14 || mode16)
   {
      j = 0;
      for (i = 0; i < 16; i++)
      {
         red   = RGBdefaults[j++];
         green = RGBdefaults[j++];
         blue  = RGBdefaults[j++];
         fg_palette(i,fg_maprgb(red,green,blue));
      }
   }

   /* copy menu screen from hidden to visual */

   fg_fadein(0);

   redraw = TRUE;
   return(OK);
}

/**********************************************************************\
*                                                                      *
*  view_ppr -- display an image from a packed pixel run file           *
*                                                                      *
\**********************************************************************/

view_ppr()
{
   static int defaults[] = {0,1,2,3,4,5,20, 7,56,57,58,59,60,61,62,63};

   static char *string[] = {
   "Display PPR file",
   "Incorrect video mode.  Press any key."
    };

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_setcolor(0);

   /* if using the proper video mode, display the image */

   if (mode16)
   {
      /* need to adjust the palettes for this picture */

      fg_move(0,ylimit);
      fg_erase();
      fg_palette(7,38);
      fg_palette(13,39);
      fg_dispfile("CASINO.PPR",xlimit+1,1);

      /* restore the hidden page */

      draw_screen();

      /* wait for a keystroke */

      fg_mousevis(ON);
      wait_for_keystroke();
      fg_mousevis(OFF);

      /* before we restore the palettes, erase the visual page */

      fg_erase();
      fg_palettes(defaults);

      /* copy menu screen from hidden to visual */

      fg_fadein(0);
   }

   /* otherwise, display an error window */

   else
   {
      info_window(160,480,145,string,2);
      wait_for_keystroke();
      fg_restore(0,xlimit,0,ylimit);
   }

   redraw = TRUE;
   return(OK);
}
