/**********************************************************************\
*                                                                      *
*  file.c -- routines for performing the functions on the FILE menu    *
*                                                                      *
\**********************************************************************/

#include "defs.h"

/**********************************************************************\
*                                                                      *
*  about_demo -- information about this demo program                   *
*                                                                      *
\**********************************************************************/

int about_demo()
{
   static char *string[] = {
   "About This Demo",
   "This demonstration program was written by",
   "Diana Gruber, using Fastgraph from Ted Gruber",
   "Software.  You may distribute this program",
   "freely, but please do not distribute any",
   "modified versions.  This program is distributed",
   "with source code.  You may use this source",
   "code in your Fastgraph applications.",
   "",
   "      Copyright (c) 1991,1992 Diana Gruber."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,10);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_docs -- information about this Fastgraph Documentation        *
*                                                                      *
\**********************************************************************/

int about_docs()
{
   static char *string[] = {
   "Fastgraph Documentation",
   "The Fastgraph manuals are exceptionally good.  The",
   "270-page Fastgraph User's Guide provides information",
   "about graphics concepts, suggestions about how to",
   "use Fastgraph, and over 130 example programs.  The",
   "Fastgraph Reference Manual provides an alphabetical",
   "summary of each Fastgraph routine.  Fastgraph's",
   "manuals enable even a novice programmer to use the",
   "product effectively right from the start."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(100,540,60,string,9);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_fg -- display about Fastgraph information                     *
*                                                                      *
\**********************************************************************/

int about_fg()
{
   static char *string[] = {
   "About Fastgraph",
   "Fastgraph, the Programmer's Graphics Library by",
   "Ted Gruber Software, is a collection of over 170",
   "highly optimized routines callable from C, C++,",
   "Turbo Pascal, QuickBASIC, and FORTRAN.",
   "Fastgraph gives a programmer complete control",
   "over the DOS-based text and graphics video",
   "environment."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,8);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_order -- information about ordering by phone                  *
*                                                                      *
\**********************************************************************/

int about_order()
{
   static char *string[] = {
   "Order by Phone/FAX",
   "Fastgraph version 2.10 is available for $149 as",
   "of February 1992.  To order Fastgraph, call our",
   "orders/info line at (702) 735-1980, or FAX your",
   "order to (702) 735-4603.",
   "",
   "You can also use these numbers for more",
   "information or to request the Fastgraph/Light",
   "evaluation kit.",
   "",
   "We accept Visa, MasterCard, and COD orders.",
   "Purchase orders are welcome from most",
   "companies, schools, and government agencies."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,13);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_site -- information about site licenses                       *
*                                                                      *
\**********************************************************************/

int about_site()
{
   static char *string[] = {
   "Site Licenses",
   "Site Licenses for Fastgraph are available.",
   "Please call, FAX, or write for details."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(152,488,60,string,3);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_tech -- information about technical support                   *
*                                                                      *
\**********************************************************************/

int about_tech()
{
   static char *string[] = {
   "Technical Support",
   "Call Dust Devil BBS (702) 796-7134 for updates,",
   "examples, source code, and echo mail support.",
   "Check your local boards for the U'NI-net / US",
   "Fastgraph support conference.  For voice support",
   "call Ted Gruber Software at (702) 735-1980.",
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,6);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  exit_program -- exit to DOS if desired                              *
*                                                                      *
\**********************************************************************/

exit_program()
{
   int xmin, xmax, ymin, ymax;

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* define the window extremes */

   xmin = 210;
   xmax = 430;
   ymin = scale(150);
   ymax = scale(200);
   if (mouse) ymax += 2 * ptsize;

   fg_mousevis(OFF);

   /* display the pop-up window */

   draw_window(xmin,xmax,ymin,ymax,"Exit");
   fg_setcolor(0);
   center_pstring("Exit to DOS?",xmin,xmax,ymin+row_offset(3));

   /* get the response and exit if desired */

   if (get_answer(xmin,xmax,ymin+row_offset(4))) terminate();

   /* otherwise, just clear the screen and return */

   fg_restore(0,xlimit,menu_bottom,ylimit);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  print_form -- print the order form                                  *
*                                                                      *
\**********************************************************************/

int print_form()
{
   FILE *stream;
   unsigned char key,aux;
   char fstring[80];

   static char *string[] = {
   "Print order form",
   "Press ESC to stop printing"
   };

   static char *string1[] = {
   "Printer Error",
   "Is the printer online?"
   };

   static char *string2[] = {
   "File Error",
   "Missing file: ORDER.FRM"
   };

   /* check that the printer is online */

   if (!printer_ready())
   {
      fg_mousevis(OFF);
      fg_restore(0,xlimit,menu_bottom,ylimit);
      info_window(120,520,60,string1,2);

      fg_mousevis(ON);
      wait_for_keystroke();

      fg_mousevis(OFF);
      fg_restore(0,xlimit,menu_bottom,ylimit);

      redraw = TRUE;
      return(OK);
   }

   /* check that the file can be opened */

   stream = fopen("order.frm","rt");
   if (stream == NULL)
   {
      fg_mousevis(OFF);
      fg_restore(0,xlimit,menu_bottom,ylimit);
      info_window(120,520,60,string2,2);

      fg_mousevis(ON);
      wait_for_keystroke();

      fg_mousevis(OFF);
      fg_restore(0,xlimit,menu_bottom,ylimit);

      redraw = TRUE;
      return(ERR);
   }

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,2);

   fg_mousevis(ON);

   /* print the file, one line at a time */

   while (TRUE)
   {
      if (fgets(fstring,80,stream) == NULL)
         break;
      fg_intkey(&key,&aux);
      if (key == ESC)
         break;
      if (fprintf(stdprn,"%s\r",fstring) == 0)
         break;
   }

   /* print form feed */

   fprintf(stdprn,"\f");

   /* close the file and flush the printer buffer */

   fclose(stream);
   fflush(stdprn);

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  shell -- create a DOS command shell                                 *
*                                                                      *
\**********************************************************************/

shell()
{
   register int page;

   /* return to the original video mode */

   for (page = 1; page < PAGES; page++)
      fg_freepage(page);
   fg_mousepos(&xmouse,&ymouse,&buttons);
   fg_setmode(old_mode);
   fg_reset();

   /* spawn the DOS command shell */

   printf("\nEnter the command EXIT to return to the Fastgraph demo.");
   spawnlp(P_WAIT,"command.com",NULL);

   /* upon return from DOS, restore the video context */

   fg_setmode(mode);
   for (page = 1; page < PAGES; page++)
      fg_allocate(page);
   fg_sethpage(1);
   visual = 0;
   hidden = 1;

   /* redraw the screen */

   redraw = TRUE;
   draw_screen();
   fg_restore(0,xlimit,0,ylimit);
   init_mouse();

   return(OK);
}
