/**********************************************************************\
*                                                                      *
*  misc.c -- sound, music, editor, etc. -- things on the MISC menu     *
*                                                                      *
\**********************************************************************/

#include "defs.h"
#include "birdmaps.h"

/**********************************************************************\
*                                                                      *
*  do_bird -- make a bitmapped bird fly across the screen              *
*                                                                      *
\**********************************************************************/

do_bird()
{
   int x;
   int frame;
   int color1,color2,color3;

   if (mode06 || mode11)
   {
      color1 = 0;
      color2 = 1;
      color3 = 1;
   }
   else if (mode14)
   {
      color1 = 4;
      color2 = 15;
      color3 = 15;
   }
   else if (mode16)
   {
      color1 = 0;
      color2 = 4;
      color3 = 12;
   }

   fg_mousevis(0);
   fg_transfer(0,xlimit,70,100,0,140,visual,hidden);

   frame = 0;
   fg_setpage(hidden);
   for (x = 0; x < 592; x+=16)
   {
      fg_transfer(0,xlimit,110,140,0,100,hidden,hidden);

      fg_setpage(hidden);
      frame = !frame;
      fg_move(x,100);
      if (frame == 0)
      {
         fg_setcolor(color1);
         fg_drawmap(bird10,6,31);
         fg_setcolor(color2);
         fg_drawmap(bird14,6,31);
         fg_setcolor(color3);
         fg_drawmap(bird112,6,31);
       
      }
      else
      {
         fg_setcolor(color1);
         fg_drawmap(bird20,5,20);
         fg_setcolor(color2);
         fg_drawmap(bird24,5,20);
         fg_setcolor(color3);
         fg_drawmap(bird212,5,20);
      }
      fg_setpage(visual);
      fg_restore(0,xlimit,70,100);
      fg_waitfor(3);
   }
   for (x = 592; x < 640; x+=16)
   {
      fg_transfer(576,639,110,140,0,100,hidden,hidden);

      fg_setpage(hidden);
      frame = !frame;
      fg_move(x-576,100);
      if (frame == 0)
      {
         fg_setcolor(color1);
         fg_drawmap(bird10,6,31);
         fg_setcolor(color2);
         fg_drawmap(bird14,6,31);
         fg_setcolor(color3);
         fg_drawmap(bird112,6,31);
       
      }
      else
      {
         fg_setcolor(color1);
         fg_drawmap(bird20,5,20);
         fg_setcolor(color2);
         fg_drawmap(bird24,5,20);
         fg_setcolor(color3);
         fg_drawmap(bird212,5,20);
      }
      fg_setpage(visual);
      fg_transfer(0,63,70,100,576,100,hidden,visual);
      fg_waitfor(3);
   }


   /* restore the background and foreground to what it was */

   fg_transfer(0,xlimit,110,140,0,100,hidden,hidden);
   fg_restore(0,xlimit,70,100);
   fg_transfer(0,xlimit,150,180,0,140,hidden,hidden);

   /* restore the screen and return to the menu */

   redraw = TRUE;
   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_editor -- call the editor                                        *
*                                                                      *
\**********************************************************************/

do_editor()
{
   char *array;
   int array_len;

   /* allocate a string to pass to the editor function */

   array = calloc(10000,sizeof(char));
   if (array == NULL)
      return(ERR);

   /* define a black background */

   background = 0;

   /* clear the screen */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* draw the box */

   fg_setcolor(0);
   fg_rect(144,487,50,180);
   fg_setcolor(15);
   fg_rect(144,487,181,195);
   fg_setcolor(0);
   fg_rect(144,487,196,196);
   center_pstring("Press F1 for help, Esc to exit",150,490,195);

   /* call the editor function */

   fg_setcolor(15);
   editor(array,148,485,53,180,20,&array_len);

   /* redraw the screen */

   draw_screen();
   fg_restore(0,xlimit,0,ylimit);
   highlight_option(4);
   fg_mousevis(ON);

   /*******************************************************************

   This editor is included for demonstration purposes only, and does
   not write anything out to a file.  If you were going to write the
   text to a text file, you would probably want to do something like
   this:

   index = 0;
   for (i = 0; i < 20; i++)
   {
      nchar = strlen(&array[index]);
      fprintf(stream,"%s\n",&ver_array[index]);
      index+=nchar;
      index+=2;

      if (index >= array_len)
         break;
   }

   Notice that the array is a collection of null terminated strings.
   Be sure to free the array when you are done.

   *******************************************************************/

   free(array);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_histogram -- create a histogram                                  *
*                                                                      *
\**********************************************************************/

do_histogram()
{
   register int i;
   int x1,x2,y1,y2;
   static char label[] = "Productivity";
   static char title[] = "See profits soar with Fastgraph!";

   static int x[] = {130, 180, 230, 280, 330, 380, 430, 480};
   static int y[] = {290, 275, 270, 265, 200, 170, 130, 100};

   /* clear the bottom of the screen */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_setpage(visual);
   fg_setcolor(0);

   y1 = scale(100);
   y2 = scale(300);

   /* axes */

   fg_rect(120,520,y2,y2);
   fg_rect(120,120,y1,y2);

   for (i = 100; i < 300; i+=20)
   {
      y1 = scale(i);
      fg_rect(120,126,y1,y1);
   }

   /* boxes */

   for (i = 0; i < 8; i++)
   {
      x1 = x[i];
      x2 = x1 + 30;
      y1 = scale(y[i]);

      fg_setcolor(11);
      fg_rect(x1,x2,y1,y2);

      fg_setcolor(0);
      fg_box(x1,x2,y1,y2);
   }

   /* label the x axis */

   x1 = 320 - length_pstring(label)/2 - 2;
   x2 = 320 + length_pstring(label)/2 + 2;
   y2 = scale(320);
   y1 = y2 - ptsize - 1;
   if (mode06 || mode11)
   {
      fg_setcolor(15);
      fg_rect(x1,x2,y1,y2);
   }
   fg_setcolor(0);
   center_pstring(label,x1,x2,y2);

   /* Profits soar with Fastgraph */

   x1 = 320 - length_pstring(title)/2 - 2;
   x2 = 320 + length_pstring(title)/2 + 2;
   y2 = scale(90);
   y1 = y2 - ptsize - 1;
   if (mode06 || mode11)
   {
      fg_setcolor(15);
      fg_rect(x1,x2,y1,y2);
   }
   fg_setcolor(0);
   center_pstring(title,x1,x2,y2);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_restore(0,xlimit,menu_bottom,ylimit);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_joystick -- demo some joystick functions                         *
*                                                                      *
\**********************************************************************/

do_joystick()
{
   static char *string1[] = {
   "Joystick",
   "Joysticks found on Port 1 and Port 2."
   };

   static char *string2[] = {
   "Joystick",
   "Joystick found on Port 1."
   };

   static char *string3[] = {
   "Joystick",
   "Joystick found on Port 2."
   };

   static char *string4[] = {
   "Joystick",
   "Joystick not found."
   };

   static int joy1_x[] = {140,200,260,140,200,260,140,200,260};
   static int joy2_x[] = {360,420,480,360,420,480,360,420,480};
   static int joy_y[] =  {110,110,110,140,140,140,170,170,170};

   unsigned char key,aux;
   int x,y;
   int count,mousex,mousey;
   int pos1,pos2,new_pos1,new_pos2;
   int joystick[2];

   /* initialize joysticks, if possible */

   if (fg_initjoy(1) == 0)
      joystick[0] = TRUE;
   else
      joystick[0] = FALSE;

   if (fg_initjoy(2) == 0)
      joystick[1] = TRUE;
   else
      joystick[1] = FALSE;

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* report status of joysticks */

   if (joystick[0] && joystick[1])
      info_window(120,520,60,string1,2);
   else if (joystick[0])
      info_window(120,520,60,string2,2);
   else if (joystick[1])
      info_window(120,520,60,string3,2);
   else
      info_window(120,520,60,string4,2);

   /* draw a grid to illustrate joystick positions */

   fg_mousevis(OFF);
   if (joystick[0])
   {
      fg_setcolor(15);
      fg_rect(120,300,100,190);
      fg_setcolor(0);
      fg_box(120,300,100,190);
      fg_box(180,240,100,190);
      fg_box(120,300,130,160);
   }

   if (joystick[1])
   {
      fg_setcolor(15);
      fg_rect(340,520,100,190);
      fg_setcolor(0);
      fg_box(340,520,100,190);
      fg_box(400,460,100,190);
      fg_box(340,520,130,160);
   }

   pos1 = 4; new_pos1 = pos1;
   pos2 = 4; new_pos2 = pos2;

   /* draw red boxes to represent joystick straight up position */

   fg_setcolor(4);
   if (joystick[0])
   {
      x = joy1_x[pos1];
      y = joy_y[pos1];
      fg_rect(x,x+20,y,y+10);
   }
   if (joystick[1])
   {
      x = joy2_x[pos2];
      y = joy_y[pos2];
      fg_rect(x,x+20,y,y+10);
   }

   fg_mousevis(ON);
   while (TRUE)
   {
      fg_waitfor(3);

      /* handle first joystick */

      if (joystick[0])
      {
         fg_intjoy(1,&key,&aux);
         if (key == CR)
            break;
         if (aux == 0)
            new_pos1 = 4;
         else if (aux >= 71 && aux <= 73)
            new_pos1 = aux - 71;
         else if (aux >= 75 && aux <= 77)
            new_pos1 = aux - 72;
         else if (aux >= 79 && aux <= 81)
            new_pos1 = aux - 73;

         if (new_pos1 != pos1)
         {
            fg_setcolor(15);
            x = joy1_x[pos1];
            y = joy_y[pos1];
            fg_mousevis(OFF);
            fg_rect(x,x+20,y,y+10);

            pos1 = new_pos1;
            fg_setcolor(4);
            x = joy1_x[pos1];
            y = joy_y[pos1];
            fg_rect(x,x+20,y,y+10);
            fg_mousevis(ON);
         }
      }

      /* handle second joystick */

      if (joystick[1])
      {
         fg_intjoy(2,&key,&aux);
         if (key == CR)
            break;
         if (aux == 0)
            new_pos2 = 4;
         else if (aux >= 71 && aux <= 73)
            new_pos2 = aux - 71;
         else if (aux >= 75 && aux <= 77)
            new_pos2 = aux - 72;
         else if (aux >= 79 && aux <= 81)
            new_pos2 = aux - 73;

         if (new_pos2 != pos2)
         {
            fg_setcolor(15);
            x = joy2_x[pos2];
            y = joy_y[pos2];
            fg_mousevis(OFF);
            fg_rect(x,x+20,y,y+10);

            pos2 = new_pos2;
            fg_setcolor(4);
            x = joy2_x[pos2];
            y = joy_y[pos2];
            fg_rect(x,x+20,y,y+10);
            fg_mousevis(ON);
         }
      }

      /* exit loop if key or mouse button pressed */

      fg_intkey(&key,&aux);
      if (key+aux > 0)
         break;

      fg_mousebut(1,&count,&mousex,&mousey);
      if (count > 0)
         break;
   }

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   redraw = TRUE;
   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_mouse -- change the mouse cursor                                 *
*                                                                      *
\**********************************************************************/

do_mouse()
{
   /* I used the MCD program from Rimrock Software to generate
      the mouse cursor array. */

   static int fgcursor[] = {
	0x0083,0x0001,0x0000,0x0018,0x0e18,0x0018,0x0018,0x001f,
	0x0000,0x0e00,0x0e00,0x0e10,0x0e10,0x0e00,0x0e00,0x0f00,
	0x0000,0x7e3c,0x7e66,0x60c2,0x60c2,0x60c2,0x7ec0,0x7ec0,
	0x60c0,0x60ce,0x60ce,0x60c6,0x60c6,0x60e6,0x607e,0x0000};

   static char *string[] = {
   "Mouse",
   "Fastgraph has routines to poll the mouse,",
   "move the mouse, turn the cursor off and on,",
   "and even change the shape of the mouse cursor."
   };

   static char *string1[] = {
   "Mouse",
   "Mouse Driver not found.",
   };

   int lastx, lasty, buttons;

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   if (mouse)
      info_window(120,520,60,string,4);
   else
      info_window(120,520,60,string1,2);

   /* if the mouse is present, change the mouse cursor */

   if (mouse)
      fg_mouseptr(fgcursor,0,0);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   fg_mousevis(OFF);

   /* restore the default cursor */

   if (mouse)
   {
      fg_mousepos(&lastx,&lasty,&buttons);  /* get current position */
      fg_mouseini();                        /* restore default cursor */
      fg_mousemov(lastx,lasty);             /* move to last position */
   }

   /* restore the screen and return to the menu */

   fg_restore(0,xlimit,menu_bottom,ylimit);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_music -- play "Stranger in Paradise"                             *
*                                                                      *
\**********************************************************************/

do_music()
{
   static char music[] =
   "T140O4L4GGO+L2DL8CDO-L4A#L8AGAA#L2O+C"
   "L4DO-AL8GFL4DDL2GL4AGL8FE"
   "L8FEL2DL4EFAGGO+L2D"
   "L8CDO-L4A#L8AGAA#L2O+CL4DO-AL8GF"
   "L4DDL2GL4AGL8FEL1F$";

   static char *string_suspend[] = {
   "Stranger in Paradise",
   "Press any key to suspend the music."
   };

   static char *string_resume[] = {
   "Stranger in Paradise",
   "Press any key to resume the music."
   };

   static char *string_stop[] = {
   "Stranger in Paradise",
   "Press any key to stop the music."
   };

   /* start the music */

   fg_musicb(music,-1);

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   /* play music until key or mouse button is pressed */

   info_window(120,520,60,string_suspend,2);
   fg_mousevis(ON);
   wait_for_keystroke();
   fg_suspend();

   /* wait for a key or mouse button to restart the music */

   info_window(120,520,60,string_resume,2);
   fg_mousevis(ON);
   wait_for_keystroke();
   fg_resume();

   /* continue playing music until key or mouse button is pressed */

   info_window(120,520,60,string_stop,2);
   fg_mousevis(ON);
   wait_for_keystroke();
   fg_hush();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   redraw = TRUE;
   return(OK);
}

/**********************************************************************\
*                                                                      *
*  do_sound -- an increasing pitch sound effect                        *
*                                                                      *
\**********************************************************************/

do_sound()
{
   register int i;

   static char *string[] = {
   "Sound Effects",
   "Creating sound effects with Fastgraph",
   "is quite simple."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   info_window(120,520,60,string,3);

   /* make the noise */

   for (i = 1000; i < 3000; i+=50)
      fg_sound(i,1);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   redraw = TRUE;
   return(OK);
}
