/**********************************************************************\
*                                                                      *
*  utility.c -- Information about snapshot, clip and convert           *
*                                                                      *
\**********************************************************************/

#include "defs.h"

/**********************************************************************\
*                                                                      *
*  about_clip -- information about the CLIP utility                    *
*                                                                      *
\**********************************************************************/

int about_clip()
{
   static char *string[] = {
   "About CLIP",
   "CLIP is a utility program that you can",
   "use to reduce the size of a pixel run file."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(136,504,60,string,3);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_convert -- information about the CONVERT utility              *
*                                                                      *
\**********************************************************************/

int about_convert()
{
   static char *string[] = {
   "About CONVERT",
   "CONVERT is a utility program that you can use to",
   "translate pixel run files between standard format",
   "and packed format.  If an image contains 16 or",
   "fewer colors, you can pack it and save disk space."
   };

   fg_mousevis(OFF);
   /* clear the screen and display the info window */

   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,5);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_editspr -- information about the EDITSPR utility              *
*                                                                      *
\**********************************************************************/

int about_editspr()
{
   static char *string[] = {
   "About EDITSPR",
   "The EDITSPR utility changes all pixel runs of",
   "one color to another color for an image stored in",
   "Fastgraph's standard pixel run (SPR) format.  It",
   "also combines adjacent pixel runs of like colors."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,5);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_grabrgb -- information about the GrabRGB utility              *
*                                                                      *
\**********************************************************************/

int about_grabrgb()
{
   static char *string[] = {
   "About GrabRGB",
   "GrabRGB is a TSR to capture color information",
   "in 256-color graphics modes.  You can use",
   "GrabRGB with SNAPSHOT to preserve the original",
   "colors of a captured image."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,5);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_hercfix -- information about the HERCFIX utility              *
*                                                                      *
\**********************************************************************/

int about_hercfix()
{
   static char *string[] = {
   "About HERCFIX",
   "The HERCFIX utility lets you use SNAPSHOT with",
   "programs that do not update the BIOS data area",
   "when establishing the Hercules graphics mode."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,4);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  about_snapshot -- information about the SNAPSHOT utility            *
*                                                                      *
\**********************************************************************/

int about_snapshot()
{
   static char *string[] = {
   "About SNAPSHOT",
   "SNAPSHOT is a TSR that you can use to capture",
   "graphic images and store them in pixel run files.",
   "Use your favorite paint program, CAD program, or",
   "any other method to display a graphic image and",
   "then use SNAPSHOT to create a pixel run file."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,6);

   /* wait for a keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* restore the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}
