/**********************************************************************\
*                                                                      *
*  video.c -- things on the video menu                                 *
*                                                                      *
\**********************************************************************/

#include "defs.h"

/**********************************************************************\
*                                                                      *
*  about_modes -- information about video modes                        *
*                                                                      *
\**********************************************************************/

int about_modes()
{
   static char *string[] = {
   "Video Modes",
   "Fastgraph supports 22 video modes.  One of the",
   "major advantages of programming with Fastgraph",
   "is the ability to write code one time to work in",
   "many video modes.  This demo, for example, will",
   "work in your choice of four video modes."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,6);

   /* wait for keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  auto_detect -- what modes are available on your machine?            *
*                                                                      *
\**********************************************************************/

int auto_detect()
{
   int x1,x2,y1,y2;
   int row,col;

   static char *string[] = {
   "Automatic Mode Detection",
   "Your system will support the following graphics modes:",
   "","","","","","","","","","","","","","","","",""
   };

   static char mode_string[] = {"This program is running in mode    "};

   static char *mode_description[] = {
   "  Mode  4  320x200 CGA 4-color",
   "  Mode  5  320x200 CGA 4-color \"colorless\"",
   "  Mode  6  640x200 CGA 2-color",
   "  Mode  9  320x200 Tandy/PCjr 16-color",
   "  Mode 11  720x348 Hercules monochrome",
   "  Mode 12  320x200 Hercules monochrome",
   "  Mode 13  320x200 EGA 16-color",
   "  Mode 14  640x200 EGA 16-color",
   "  Mode 15  640x350 EGA monochrome",
   "  Mode 16  640x350 EGA 16-color",
   "  Mode 17  640x480 VGA/MCGA 2-color",
   "  Mode 18  640x480 VGA 16-color",
   "  Mode 19  320x200 VGA/MCGA 256-color",
   "  Mode 20  320x200 VGA 256-color",
   "  Mode 21  320x400 VGA 256-color",
   "  Mode 22  320x240 VGA 256-color (mode X)",
   "  Mode 23  320x480 VGA 256-color"
   };

   static int mode_number[] = {
   4,5,6,9,11,12,13,14,15,16,17,18,19,20,21,22,23
   };

   register int i, j;

   /* test the modes and build an array of description strings */

   j = 2;
   for (i = 0; i <= sizeof(mode_number)/sizeof(int); i++)
   {
      if (fg_testmode(mode_number[i],1))
         string[j++] = mode_description[i];
   }

   /* insert the current mode in the last string */

   sprintf(&mode_string[32],"%d.",fg_getmode());
   string[j++] = mode_string;

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_setpage(hidden);

   if (mode11)
   {
      x1 = 80;
      x2 = 592;
   }
   else
   {
      x1 = 100;
      x2 = 562;
   }
   y1 = fg_yconvert(4);
   y2 = fg_yconvert(5+j)+scale(10);

   draw_window(x1,x2,y1,y2,string[0]);
   fg_setcolor(0);

   row = 6;
   if (mode11)
      col = 11;
   else
      col = 15;
   for (i = 1; i < j; i++)
   {
      put_tstring(string[i],row,col);
      row++;
   }

   fg_setcolor(0);
   fg_setpage(visual);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_setpage(hidden);

   /* redraw the screen under the window */

   x2 += 3;

   if (mode06 || mode11)
      fg_drect(x1,x2,y1,y2+2,matrix1);
   else
   {
      fg_setcolor(15);
      fg_rect(x1,x2,y1,y2+2);
      fg_setcolor(14);
      fg_drect(x1,x2,y1,y2+2,matrix2);
   }

   /* wait for keystroke or mouse button */

   fg_setpage(visual);
   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  coordinates -- about coordinate systems                             *
*                                                                      *
\**********************************************************************/

int coordinates()
{
   static char *string[] = {
   "Coordinate Systems",
   "Fastgraph supports 3 coordinate systems:  Character",
   "Space, Screen Space and World Space.  Character Space",
   "is defined in rows and columns.  Screen Space is defined",
   "by the pixel resolution of the video mode.  World Space",
   "is a floating point coordinate system defined by the",
   "programmer."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(90,550,60,string,7);

   /* wait for keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}


/**********************************************************************\
*                                                                      *
*  virtual_pages -- about virtual pages                                *
*                                                                      *
\**********************************************************************/

int logical_pages()
{
   static char *string[] = {
   "Logical Pages",
   "Logical pages let you swap out the contents of a",
   "physical or virtual page to conventional memory,",
   "expanded memory (EMS), or extended memory (XMS)",
   "and then swap it back in when you need it.  Logical",
   "pages are available in all video modes."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(100,540,60,string,6);

   /* wait for keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}
/**********************************************************************\
*                                                                      *
*  physical_pages -- about physical pages                              *
*                                                                      *
\**********************************************************************/

int physical_pages()
{
   static char *string[] = {
   "Physical Pages",
   "Physical pages are useful for fast image display",
   "and animation.  The number of physical pages",
   "available is dependent on the video mode and the",
   "amount of memory on your video card."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(120,520,60,string,5);

   /* wait for keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}

/**********************************************************************\
*                                                                      *
*  virtual_pages -- about virtual pages                                *
*                                                                      *
\**********************************************************************/

int virtual_pages()
{
   static char *string[] = {
   "Virtual Pages",
   "If you don't have enough memory on your video card",
   "for physical pages, Fastgraph will let you use RAM to",
   "create virtual pages in some video modes."
   };

   /* clear the screen and display the info window */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);
   info_window(100,540,60,string,4);

   /* wait for keystroke or mouse button */

   fg_mousevis(ON);
   wait_for_keystroke();

   /* clear the screen and return to the menu */

   fg_mousevis(OFF);
   fg_restore(0,xlimit,menu_bottom,ylimit);

   fg_mousevis(ON);
   redraw = TRUE;

   return(OK);
}
