#include <stdafx.h> 
#include "resource.h"
extern "C"
{
#include "slider.h"
}
#include "cslider.h"          
 
          
CSlider::CSlider(HWND hWnd,WORD id,DWORD dwStyles,LPSTR szTitle,int x, int y, int width, int height)
{   
    registerSlider();
    
    hThumbBM=hFocusBM=hBezelBM=NULL;
                
    m_hWnd=::CreateWindow("slider", szTitle,dwStyles,
                             x, y, width, height,
                             hWnd, (HMENU)id, 
                             AfxGetInstanceHandle(), 0L);
                   
}

CSlider::~CSlider()
{   
    if (hThumbBM)
        DeleteObject(hThumbBM);
    if (hFocusBM)
        DeleteObject(hFocusBM);
    if (hBezelBM)
        DeleteObject(hBezelBM);
}

WORD CSlider::getPos()
{  
  
    return (WORD)::SendMessage(m_hWnd,SCM_GETPOS,0,0L);
}

void CSlider::setPos(WORD wPos)
{ 
    ::SendMessage(m_hWnd,SCM_SETPOS,(WPARAM)wPos,0L);
}

LONG CSlider::getRange()
{            
    return ::SendMessage(m_hWnd,SCM_GETRANGE,0,0L);
}

void CSlider::setRange(WORD wLow,WORD wHigh)
{
    ::SendMessage(m_hWnd,SCM_SETRANGE,0,MAKELONG(wLow,wHigh));
}

void CSlider::setInnerBevelStyle(WORD wStyle)
{ 

    ::SendMessage(m_hWnd,SCM_SETBEVELSTYLE,SCBEVEL_INNER,wStyle);
}                                                              

void CSlider::setOuterBevelStyle(WORD wStyle)
{
    ::SendMessage(m_hWnd,SCM_SETBEVELSTYLE,SCBEVEL_OUTER,wStyle);

}

void CSlider::setInnerBevelWidth(WORD wWidth)
{
    ::SendMessage(m_hWnd,SCM_SETWIDTH,SCBEVEL_INNER,wWidth);
}

void CSlider::setOuterBevelWidth(WORD wWidth)
{
    ::SendMessage(m_hWnd,SCM_SETWIDTH,SCBEVEL_OUTER,wWidth);
}      

void CSlider::setBorderWidth(WORD wWidth)
{
    ::SendMessage(m_hWnd,SCM_SETWIDTH,SCBORDER,wWidth);
    
     hThumbBM=0;
}

void CSlider::setThumbBitMap(WORD idBMP)
{
    if (hThumbBM)
        DeleteObject(hThumbBM);
                      
    if (idBMP)
        hThumbBM=LoadBitmap(AfxGetInstanceHandle(),
                        MAKEINTRESOURCE(idBMP));
    else
        hThumbBM=NULL;
    
    ::SendMessage(m_hWnd,SCM_SETBITMAP,SCB_THUMB,(LPARAM)(WORD)hThumbBM);
}
          
void CSlider::setFocusBitMap(WORD idBMP)
{
    if (hFocusBM)
        DeleteObject(hFocusBM);
  
    if (idBMP)      
        hFocusBM=LoadBitmap(AfxGetInstanceHandle()
                        ,MAKEINTRESOURCE(idBMP));
    else
        hFocusBM=NULL;
    
    ::SendMessage(m_hWnd,SCM_SETBITMAP,SCB_THUMBFOCUS,(LPARAM)(WORD)hFocusBM);
}

void CSlider::setBezelBitMap(WORD idBMP)
{
    if (hBezelBM)
        DeleteObject(hBezelBM);
        
    hBezelBM=LoadBitmap(AfxGetInstanceHandle(),
                        MAKEINTRESOURCE(idBMP));
    
    ::SendMessage(m_hWnd,SCM_SETBITMAP,SCB_BEZEL,(LPARAM)(WORD)hBezelBM);
}


void CSlider::setTickStyle(WORD nStyle)
{
    ::SendMessage(m_hWnd,SCM_SETTICKSTYLE,nStyle,0L);
}