// slidevw.cpp : implementation of the CSlidetstView class
//

#include "stdafx.h"
#include "slidetst.h"

#include "slidedoc.h"
#include "cslider.h"
#include "slidevw.h"
#include "range.h" 
#include "slider.h"
#include "widths.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView

IMPLEMENT_DYNCREATE(CSlidetstView, CView)

BEGIN_MESSAGE_MAP(CSlidetstView, CView)
    //{{AFX_MSG_MAP(CSlidetstView)
    ON_WM_CREATE()
    ON_WM_DESTROY()
    ON_WM_HSCROLL()
    ON_WM_VSCROLL()
    ON_WM_CTLCOLOR()
    ON_COMMAND(IDM_SETHPOS, OnSethpos)
    ON_COMMAND(IDM_SETHRANGE, OnSethrange)
    ON_COMMAND(IDM_SETVPOS, OnSetvpos)
    ON_COMMAND(IDM_SETVRANGE, OnSetvrange)
    ON_COMMAND(IDM_ENABLEVERT, OnEnablevert)
    ON_COMMAND(IDM_ENABLEHORZ, OnEnablehorz)
    ON_COMMAND(IDM_DISABLEVERT, OnDisablevert)
    ON_COMMAND(IDM_DISABLEHORZ, OnDisablehorz)
    ON_COMMAND(IDM_GETHRANGE, OnGethrange)
    ON_COMMAND(IDM_GETVRANGE, OnGetvrange)
    ON_COMMAND(IDM_BITMAP, OnBitmap)
    ON_COMMAND(IDM_DEFAULT, OnDefault)
    ON_COMMAND(IDM_HBORDERWIDTH, OnHborderwidth)
    ON_COMMAND(IDM_HIBEVELFRAME, OnHibevelframe)
    ON_COMMAND(IDM_HIBEVELINSET, OnHibevelinset)
    ON_COMMAND(IDM_HIBEVELNONE, OnHibevelnone)
    ON_COMMAND(IDM_HIBEVELRAISED, OnHibevelraised)
    ON_COMMAND(IDM_HIBEVELWIDTH, OnHibevelwidth)
    ON_COMMAND(IDM_HOBEVELFRAME, OnHobevelframe)
    ON_COMMAND(IDM_HOBEVELINSET, OnHobevelinset)
    ON_COMMAND(IDM_HOBEVELNONE, OnHobevelnone)
    ON_COMMAND(IDM_HOBEVELRAISED, OnHobevelraised)
    ON_COMMAND(IDM_HOBEVELWIDTH, OnHobevelwidth)
    ON_COMMAND(IDM_HTICKINSET, OnHtickinset)
    ON_COMMAND(IDM_HTICKNORMAL, OnHticknormal)
    ON_COMMAND(IDM_HTICKRAISED, OnHtickraised)
    ON_COMMAND(IDM_VBORDERWIDTH, OnVborderwidth)
    ON_COMMAND(IDM_VIBEVELFRAME, OnVibevelframe)
    ON_COMMAND(IDM_VIBEVELINSET, OnVibevelinset)
    ON_COMMAND(IDM_VIBEVELNONE, OnVibevelnone)
    ON_COMMAND(IDM_VIBEVELRAISED, OnVibevelraised)
    ON_COMMAND(IDM_VOBEVELFRAME, OnVobevelframe)
    ON_COMMAND(IDM_VOBEVELINSET, OnVobevelinset)
    ON_COMMAND(IDM_VOBEVELNONE, OnVobevelnone)
    ON_COMMAND(IDM_VOBEVELRAISED, OnVobevelraised)
    ON_COMMAND(IDM_VTICKINSET, OnVtickinset)
    ON_COMMAND(IDM_VTICKRAISED, OnVtickraised)
    ON_COMMAND(IDM_VBITMAPTHUMB, OnVbitmapthumb)
    ON_COMMAND(IDM_VDEFAULTTHUMB, OnVdefaultthumb)
    ON_COMMAND(IDM_VTICKNORMAL, OnVticknormal)
    ON_COMMAND(IDM_SETHPOS, OnSethpos)
    ON_COMMAND(IDM_VIBEVELWIDTH, OnVibevelwidth)
    ON_COMMAND(IDM_VOBEVELWIDTH, OnVobevelwidth)
    //}}AFX_MSG_MAP
    // Standard printing commands
    ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
    ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView construction/destruction

CSlidetstView::CSlidetstView()
{  

}

CSlidetstView::~CSlidetstView()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView drawing

void CSlidetstView::OnDraw(CDC* pDC)
{
    CSlidetstDoc* pDoc = GetDocument();

    // TODO: add draw code here
}

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView printing

BOOL CSlidetstView::OnPreparePrinting(CPrintInfo* pInfo)
{
    // default preparation
    return DoPreparePrinting(pInfo);
}

void CSlidetstView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
    // TODO: add extra initialization before printing
}

void CSlidetstView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
    // TODO: add cleanup after printing
}




/////////////////////////////////////////////////////////////////////////////
// CSlidetstView diagnostics

#ifdef _DEBUG
void CSlidetstView::AssertValid() const
{
    CView::AssertValid();
}

void CSlidetstView::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CSlidetstDoc* CSlidetstView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSlidetstDoc)));
    return (CSlidetstDoc*) m_pDocument;
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSlidetstView message handlers

int CSlidetstView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // Create a vertical slider (id hardcoded at 50)
    pVSlider=new CSlider(m_hWnd,50,
                        WS_CHILD|WS_VISIBLE|SCS_INVERTRANGE|
                        SCS_VERTICAL|SCS_TEXTHASRANGE|
                        SCS_RIGHTTICKS,
                        "1,2000,25",10,20,44,130);
 
    // Create a horizontal slider (id hardcoded at 51)
    pHSlider=new CSlider(m_hWnd,51,
                        WS_CHILD|WS_VISIBLE|SCS_INVERTRANGE|
                        SCS_HORIZONTAL|SCS_TEXTHASRANGE|
                        SCS_TOPTICKS|SCS_BOTTOMTICKS,
                        "1,2000,25",60,110,200,50); 
                        
    // Create a text window to display the current position
    RECT    r={60,20,120,44};
    
    vposWin.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,
                  r,this,12);
                  
    vposWin.ShowWindow(1);
                  
    r.top=80;
    r.bottom=104;
                
    hposWin.Create(WS_VISIBLE|WS_CHILD|WS_BORDER,
                  r,this,13);
                  
    hposWin.ShowWindow(1);                  
    return 0;
}

void CSlidetstView::OnDestroy()
{
    CView::OnDestroy();
    
    // TODO: Add your message handler code here
    delete pVSlider;
    delete pHSlider;
}

void CSlidetstView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // See if this is the slider 
    if (pScrollBar->m_hWnd==pHSlider->m_hWnd)
    {
    
        int curPos=pHSlider->getPos(); 
        
            // This is for testing only - you only need to use nPos
            //  and would not normally call getPos to get the position
        ASSERT (curPos==(int)nPos);
        
        char szText[20];
    
        wsprintf(szText,"%d",nPos);                 
        hposWin.SetWindowText(szText);    
    }
}

HBRUSH CSlidetstView::OnCtlColor(CDC* pDC,CWnd* pWnd,UINT nCtlColor)
{
   if (pWnd->m_hWnd==pVSlider->m_hWnd||pWnd->m_hWnd==pHSlider->m_hWnd)
   {                            
        pDC->SetBkColor(RGB(192,192,192));
   }
   return NULL;
}


void CSlidetstView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // See if this is the slider 
    if (pScrollBar->m_hWnd==pVSlider->m_hWnd)
    {
    
        int curPos=pVSlider->getPos(); 
        
            // This is for testing only - you only need to use nPos
            //  and would not normally call getPos to get the position
        ASSERT (curPos==(int)nPos);
    
            // Display the current position    
        char szText[20];
    
        wsprintf(szText,"%d",nPos);                 
        vposWin.SetWindowText(szText);    
    }
}


void CSlidetstView::OnSethrange()
{
  CRange    dlg;
  
  if (dlg.DoModal())
  {
     pHSlider->setRange(atoi(dlg.m_Low.GetBuffer(10)),
                        atoi(dlg.m_High.GetBuffer(10)));  
  }
    
}

void CSlidetstView::OnSetvpos()
{
    char    szTemp[30];           
    int     nVal;
    
    vposWin.GetWindowText(szTemp,30);
    nVal=atoi(szTemp);
    pVSlider->setPos(nVal);
}

void CSlidetstView::OnSetvrange()
{
  CRange    dlg;
    
  if (dlg.DoModal())
  {                              
     pVSlider->setRange(atoi(dlg.m_Low.GetBuffer(10)),
                        atoi(dlg.m_High.GetBuffer(10)));
  }
}

void CSlidetstView::OnSethpos()
{
    char    szTemp[30];           
    int     nVal;
    
    hposWin.GetWindowText(szTemp,30);
    nVal=atoi(szTemp);
    pHSlider->setPos(nVal);
}

void CSlidetstView::OnEnablevert()
{
   pVSlider->EnableWindow(TRUE);       
}

void CSlidetstView::OnEnablehorz()
{
   pHSlider->EnableWindow(TRUE);        
}

void CSlidetstView::OnDisablevert()
{
   pVSlider->EnableWindow(FALSE);       
}

void CSlidetstView::OnDisablehorz()
{        
   pHSlider->EnableWindow(FALSE);
}

void CSlidetstView::OnGethrange()
{
    long    lVal;
    char    szMsg[100];
        
    lVal=pHSlider->getRange();
    wsprintf(szMsg,"%d to %d",LOWORD(lVal),HIWORD(lVal));
    AfxMessageBox(szMsg);
}

void CSlidetstView::OnGetvrange()
{
    long    lVal;
    char    szMsg[100];
        
    lVal=pVSlider->getRange();
    wsprintf(szMsg,"%d to %d",LOWORD(lVal),HIWORD(lVal));
    AfxMessageBox(szMsg);
    
}

void CSlidetstView::OnBitmap()
{
    pVSlider->setBezelBitMap(IDB_BITMAP9);  
}

void CSlidetstView::OnDefault()
{
    pVSlider->setBezelBitMap(NULL);    
}

void CSlidetstView::OnHborderwidth()
{
    CWidths    dlg;
    int        nWidth;
    
    dlg.m_title="Border Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pHSlider->setBorderWidth(nWidth);
    } 
}

void CSlidetstView::OnHibevelframe()
{
     pHSlider->setInnerBevelStyle(SCS_FRAME);  
}

void CSlidetstView::OnHibevelinset()
{
     pHSlider->setInnerBevelStyle(SCS_INSET);  
}

void CSlidetstView::OnHibevelnone()
{
     pHSlider->setInnerBevelStyle(SCS_NONE);  
}

void CSlidetstView::OnHibevelraised()
{
     pHSlider->setInnerBevelStyle(SCS_RAISED);
}

void CSlidetstView::OnHibevelwidth()
{
    CWidths    dlg;
    int        nWidth;
    
    dlg.m_title="Inner Bevel Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pHSlider->setInnerBevelWidth(nWidth);    
    }
}

void CSlidetstView::OnHobevelframe()
{
     pHSlider->setOuterBevelStyle(SCS_FRAME); 
}

void CSlidetstView::OnHobevelinset()
{
     pHSlider->setOuterBevelStyle(SCS_INSET);
}

void CSlidetstView::OnHobevelnone()
{
     pHSlider->setOuterBevelStyle(SCS_NONE); 
}

void CSlidetstView::OnHobevelraised()
{
     pHSlider->setOuterBevelStyle(SCS_RAISED); 
}

void CSlidetstView::OnHobevelwidth()
{
    CWidths    dlg; 
    int        nWidth;
        
    dlg.m_title="Outer Bevel Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pHSlider->setOuterBevelWidth(nWidth);    
    }
}

void CSlidetstView::OnHtickinset()
{
     pHSlider->setTickStyle(SCTICK_INSET); 
}


void CSlidetstView::OnHticknormal()
{
     pHSlider->setTickStyle(SCTICK_NORMAL); 
}

void CSlidetstView::OnHtickraised()
{
     pHSlider->setTickStyle(SCTICK_RAISED);  
}


void CSlidetstView::OnVborderwidth()
{
    CWidths    dlg;
    int        nWidth;
        
    dlg.m_title="Border Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pVSlider->setBorderWidth(nWidth);    
    } 
}

void CSlidetstView::OnVibevelframe()
{
     pVSlider->setInnerBevelStyle(SCS_FRAME);  
}

void CSlidetstView::OnVibevelinset()
{
     pVSlider->setInnerBevelStyle(SCS_INSET);  
}

void CSlidetstView::OnVibevelnone()
{
     pVSlider->setInnerBevelStyle(SCS_NONE); 
}

void CSlidetstView::OnVibevelraised()
{
     pVSlider->setInnerBevelStyle(SCS_RAISED);  
}

void CSlidetstView::OnVobevelframe()
{
     pVSlider->setOuterBevelStyle(SCS_FRAME); 
}

void CSlidetstView::OnVobevelinset()
{
     pVSlider->setOuterBevelStyle(SCS_INSET);  
}

void CSlidetstView::OnVobevelnone()
{
     pVSlider->setOuterBevelStyle(SCS_NONE);  
}

void CSlidetstView::OnVobevelraised()
{
     pVSlider->setOuterBevelStyle(SCS_RAISED); 
}

void CSlidetstView::OnVtickinset()
{
     pVSlider->setTickStyle(SCTICK_INSET);  
}

void CSlidetstView::OnVticknormal()
{
     pVSlider->setTickStyle(SCTICK_NORMAL); 
}

void CSlidetstView::OnVtickraised()
{
     pVSlider->setTickStyle(SCTICK_RAISED);  
}

void CSlidetstView::OnVbitmapthumb()
{
    pVSlider->setThumbBitMap(IDB_BITMAP6);
    pVSlider->setFocusBitMap(IDB_BITMAP5);
}

void CSlidetstView::OnVdefaultthumb()
{
    pVSlider->setThumbBitMap(NULL);
    pVSlider->setFocusBitMap(NULL);
}



void CSlidetstView::OnVibevelwidth()
{
    CWidths    dlg;
    int        nWidth;
        
    dlg.m_title="Inner Bevel Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pVSlider->setInnerBevelWidth(nWidth);    
    }   
}

void CSlidetstView::OnVobevelwidth()
{
    CWidths    dlg;
    int        nWidth;
        
    dlg.m_title="Outer Bevel Width:";    
    if (dlg.DoModal())
    {
        nWidth=atoi(dlg.m_width.GetBuffer(3)); 
        pVSlider->setOuterBevelWidth(nWidth);    
    } 
}
