Option Explicit

' Copyright  1993, 1994 by Computer Technologies, Inc. All rights reserved.

' *** TEXT EDIT FUNCTIONS SECTION ***

' Text function constants
Global Const TE_UNDO = 0
Global Const TE_APPEND = 1
Global Const TE_CUT = 2
Global Const TE_COPY = 3
Global Const TE_PASTE = 4
Global Const TE_DELETE = 5
Global Const TE_JUSTIFYLEFT = 6
Global Const TE_JUSTIFYRIGHT = 7
Global Const TE_JUSTIFYCENTER = 8

Global Const WM_USER = &H400
Global Const EM_UNDO = WM_USER + 23

Declare Function APISendMessage Lib "User" Alias "SendMessage" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, lParam As Any) As Long

Sub UT_TextFunctions (frmCalling As Form, nTextAction As Integer)

' Copyright  1993, 1994 by Computer Technologies, Inc. All rights reserved.

    Dim nResult      As Integer

    On Error Resume Next

    Select Case nTextAction
	Case TE_UNDO
	    nResult = APISendMessage(frmCalling.ActiveControl.hWnd, EM_UNDO, 0, 0)

	Case TE_APPEND
	    ClipBoard.SetText ClipBoard.GetText() & frmCalling.ActiveControl.SelText
	    
	Case TE_CUT
	    ClipBoard.SetText frmCalling.ActiveControl.SelText
	    frmCalling.ActiveControl.SelText = ""

	Case TE_COPY
	    ClipBoard.SetText frmCalling.ActiveControl.SelText
	
	Case TE_PASTE
	    frmCalling.ActiveControl.SelText = ClipBoard.GetText()
	    
	Case TE_DELETE
	    If frmCalling.ActiveControl.SelLength = 0 Then
		frmCalling.ActiveControl.SelLength = 1
	    End If
	    frmCalling.ActiveControl.SelText = ""

    End Select

    On Error GoTo 0

End Sub

Function UT_TextJustify (tInputStr As String, nFinalSize As Integer, nPadAction As Integer) As String

' Copyright  1993, 1994 by Computer Technologies, Inc. All rights reserved.
      
' This Function returns the input string as a string of the specified size and justified
' according to the action requested. Use the global constants TE_JUSTIFYLEFT, TE_JUSTIFYRIGHT,
' and TE_JUSTIFYCENTER to determine the justification action.

' To insure proper display spacing, use a monospaced font such as Courier or Courier New.
    
    Dim tTempStr        As String

    tTempStr = Trim$(tInputStr)

    If tInputStr = "" Then
	UT_TextJustify = Space$(nFinalSize)
	Exit Function
    End If
 
    If Len(tTempStr) > nFinalSize Then
	UT_TextJustify = Left$(tTempStr, nFinalSize)
	Exit Function
    End If
		   
    Select Case nPadAction
  
	Case TE_JUSTIFYLEFT                     ' Left Justify
	    UT_TextJustify = tTempStr + Left$(Space$(nFinalSize), (nFinalSize - Len(tTempStr)))
     
	Case TE_JUSTIFYRIGHT                    ' Right Justify
	    UT_TextJustify = Left$(Space$(nFinalSize), (nFinalSize - Len(tTempStr))) + tTempStr
  
	Case TE_JUSTIFYCENTER                   ' Center Justify
	    tTempStr = Space$((nFinalSize - Len(tTempStr)) \ 2) & tTempStr & Space$((nFinalSize - Len(tTempStr)) \ 2)
	    If Len(tTempStr) < nFinalSize Then  ' Add trailing spaces for odd length input string
		tTempStr = tTempStr + Left$(Space$(nFinalSize), (nFinalSize - Len(tTempStr)))
	    End If
	    UT_TextJustify = tTempStr

	Case Else
	    UT_TextJustify = ""
  
    End Select

End Function

